/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.util.RandomUtils;

public class DefaultSubChainSelector
extends AbstractSelector
implements SubChainSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntityIndependentValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final int minimumSubChainSize;
    protected final int maximumSubChainSize;
    protected List<SubChain> anchorTrailingChainList = null;

    public DefaultSubChainSelector(EntityIndependentValueSelector valueSelector, boolean randomSelection, int minimumSubChainSize, int maximumSubChainSize) {
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.minimumSubChainSize = minimumSubChainSize;
        this.maximumSubChainSize = maximumSubChainSize;
        if (!valueSelector.getVariableDescriptor().isChained()) {
            throw new IllegalArgumentException("The selector (" + this + ")'s valueSelector (" + valueSelector + ") must have a chained variableDescriptor chained (" + valueSelector.getVariableDescriptor().isChained() + ").");
        }
        if (valueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        if (minimumSubChainSize < 1) {
            throw new IllegalStateException("The selector (" + this + ")'s minimumSubChainSize (" + minimumSubChainSize + ") must be at least 1.");
        }
        if (minimumSubChainSize > maximumSubChainSize) {
            throw new IllegalStateException("The minimumSubChainSize (" + minimumSubChainSize + ") must be at least maximumSubChainSize (" + maximumSubChainSize + ").");
        }
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.valueSelector.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        ScoreDirector scoreDirector = solverScope.getScoreDirector();
        PlanningVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        Class<?> entityClass = variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass();
        long valueSize = this.valueSelector.getSize();
        if (valueSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + this.valueSelector + ") with valueSize (" + valueSize + ") which is higher than Integer.MAX_VALUE.");
        }
        LinkedList anchorList = new LinkedList();
        for (Object value : this.valueSelector) {
            if (entityClass.isAssignableFrom(value.getClass())) continue;
            anchorList.add(value);
        }
        this.anchorTrailingChainList = new ArrayList<SubChain>(anchorList.size());
        int anchorChainInitialCapacity = (int)valueSize / anchorList.size() + 1;
        for (Object anchor : anchorList) {
            ArrayList<Object> anchorChain = new ArrayList<Object>(anchorChainInitialCapacity);
            Object trailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, anchor);
            while (trailingEntity != null) {
                anchorChain.add(trailingEntity);
                trailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, trailingEntity);
            }
            if (anchorChain.size() < this.minimumSubChainSize) continue;
            this.anchorTrailingChainList.add(new SubChain(anchorChain));
        }
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.anchorTrailingChainList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (SubChain anchorTrailingChain : this.anchorTrailingChainList) {
            long n = (long)Math.min(this.maximumSubChainSize, anchorTrailingChain.getEntityList().size()) - (long)this.minimumSubChainSize + 1L;
            size += n * (n + 1L) / 2L;
        }
        return size;
    }

    @Override
    public Iterator<SubChain> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.iterator());
        }
        return new RandomSubChainIterator();
    }

    @Override
    public ListIterator<SubChain> listIterator() {
        if (!this.randomSelection) {
            throw new UnsupportedOperationException("This class (" + this.getClass() + ") does not support the listIterator() methods yet. " + "As a result you can only use SubChain based swap moves with randomSelection true. " + " https://issues.jboss.org/browse/JBRULES-3586");
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<SubChain> listIterator(int index) {
        if (!this.randomSelection) {
            throw new UnsupportedOperationException("This class (" + this.getClass() + ") does not support the listIterator() methods yet. " + "As a result you can only use SubChain based swap moves with randomSelection true. " + " https://issues.jboss.org/browse/JBRULES-3586");
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelector + ")";
    }

    private class RandomSubChainIterator
    extends UpcomingSelectionIterator<SubChain> {
        private RandomSubChainIterator() {
            if (DefaultSubChainSelector.this.anchorTrailingChainList.isEmpty()) {
                this.upcomingSelection = null;
            } else {
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            int anchorTrailingChainListIndex = DefaultSubChainSelector.this.workingRandom.nextInt(DefaultSubChainSelector.this.anchorTrailingChainList.size());
            List<Object> anchorTrailingChain = DefaultSubChainSelector.this.anchorTrailingChainList.get(anchorTrailingChainListIndex).getEntityList();
            int n = Math.min(DefaultSubChainSelector.this.maximumSubChainSize, anchorTrailingChain.size()) - DefaultSubChainSelector.this.minimumSubChainSize + 1;
            long size = (long)n * ((long)n + 1L) / 2L;
            long sizeIndex = RandomUtils.nextLong(DefaultSubChainSelector.this.workingRandom, size);
            int fromIndex = 0;
            long subChainSize = sizeIndex;
            for (long maxSize = (long)n; subChainSize >= maxSize; --maxSize) {
                subChainSize -= maxSize;
                ++fromIndex;
            }
            int toIndex = fromIndex + (int)subChainSize + DefaultSubChainSelector.this.minimumSubChainSize;
            this.upcomingSelection = new SubChain(anchorTrailingChain.subList(fromIndex, toIndex));
        }
    }

    private class OriginalSubChainIterator
    extends UpcomingSelectionIterator<SubChain> {
        private final Iterator<SubChain> anchorTrailingChainIterator;
        private List<Object> anchorTrailingChain;
        private int anchorTrailingChainSize;
        private int fromIndex;
        private int toIndex;

        public OriginalSubChainIterator(Iterator<SubChain> anchorTrailingChainIterator) {
            this.anchorTrailingChainIterator = anchorTrailingChainIterator;
            this.anchorTrailingChainSize = -1;
            this.fromIndex = -1;
            this.toIndex = -1;
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            ++this.toIndex;
            if (this.toIndex > this.anchorTrailingChainSize) {
                ++this.fromIndex;
                this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                while (this.toIndex > this.anchorTrailingChainSize) {
                    if (!this.anchorTrailingChainIterator.hasNext()) {
                        this.upcomingSelection = null;
                        return;
                    }
                    this.anchorTrailingChain = this.anchorTrailingChainIterator.next().getEntityList();
                    this.anchorTrailingChainSize = Math.min(DefaultSubChainSelector.this.maximumSubChainSize, this.anchorTrailingChain.size());
                    this.fromIndex = 0;
                    this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                }
            }
            this.upcomingSelection = new SubChain(this.anchorTrailingChain.subList(this.fromIndex, this.toIndex));
        }
    }
}

