/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.termination.Termination;

public class AndCompositeTermination
extends AbstractCompositeTermination {
    public AndCompositeTermination() {
    }

    public AndCompositeTermination(Termination ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isSolverTerminated(solverScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isPhaseTerminated(phaseScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }
}

