/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ValueSelectorConfigTest {
    @Test
    public void phaseOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void justInTimeOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
    }

    @Test
    public void phaseRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void justInTimeRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
    }

    @Test
    public void phaseShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingValueSelector.class, valueSelector);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, ((ShufflingValueSelector)valueSelector).getChildValueSelector());
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingValueSelector.class, valueSelector);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, ((ShufflingValueSelector)valueSelector).getChildValueSelector());
        Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)valueSelector.getCacheType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void justInTimeShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
    }
}

