/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.DefaultSubChainSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class DefaultSubChainSelectorTest {
    @Test
    public void original() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, b1, b2});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4, b0, b1, b2);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.runAssertsOriginal1(subChainSelector);
        subChainSelector.stepEnded(stepScopeA1);
        a4.setChainedObject(a2);
        a3.setChainedObject(b1);
        b2.setChainedObject(a3);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA2);
        this.runAssertsOriginal2(subChainSelector);
        subChainSelector.stepEnded(stepScopeA2);
        subChainSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        subChainSelector.stepStarted(stepScopeB1);
        this.runAssertsOriginal2(subChainSelector);
        subChainSelector.stepEnded(stepScopeB1);
        subChainSelector.phaseEnded(phaseScopeB);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 3);
    }

    private void runAssertsOriginal1(DefaultSubChainSelector subChainSelector) {
        Iterator iterator = subChainSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextSubChain(iterator, "a1");
        this.assertNextSubChain(iterator, "a1", "a2");
        this.assertNextSubChain(iterator, "a1", "a2", "a3");
        this.assertNextSubChain(iterator, "a1", "a2", "a3", "a4");
        this.assertNextSubChain(iterator, "a2");
        this.assertNextSubChain(iterator, "a2", "a3");
        this.assertNextSubChain(iterator, "a2", "a3", "a4");
        this.assertNextSubChain(iterator, "a3");
        this.assertNextSubChain(iterator, "a3", "a4");
        this.assertNextSubChain(iterator, "a4");
        this.assertNextSubChain(iterator, "b1");
        this.assertNextSubChain(iterator, "b1", "b2");
        this.assertNextSubChain(iterator, "b2");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)13L, (long)subChainSelector.getSize());
    }

    private void runAssertsOriginal2(DefaultSubChainSelector subChainSelector) {
        Iterator iterator = subChainSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextSubChain(iterator, "a1");
        this.assertNextSubChain(iterator, "a1", "a2");
        this.assertNextSubChain(iterator, "a1", "a2", "a4");
        this.assertNextSubChain(iterator, "a2");
        this.assertNextSubChain(iterator, "a2", "a4");
        this.assertNextSubChain(iterator, "a4");
        this.assertNextSubChain(iterator, "b1");
        this.assertNextSubChain(iterator, "b1", "a3");
        this.assertNextSubChain(iterator, "b1", "a3", "b2");
        this.assertNextSubChain(iterator, "a3");
        this.assertNextSubChain(iterator, "a3", "b2");
        this.assertNextSubChain(iterator, "b2");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)12L, (long)subChainSelector.getSize());
    }

    @Test
    public void emptyEntitySelectorOriginal() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[0]);
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, b0);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyOriginal(subChainSelector);
        subChainSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyOriginal(subChainSelector);
        subChainSelector.stepEnded(stepScopeA2);
        subChainSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        subChainSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyOriginal(subChainSelector);
        subChainSelector.stepEnded(stepScopeB1);
        subChainSelector.phaseEnded(phaseScopeB);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 3);
    }

    private void runAssertsEmptyOriginal(DefaultSubChainSelector subChainSelector) {
        Iterator iterator = subChainSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)0L, (long)subChainSelector.getSize());
    }

    private void assertNextSubChain(Iterator<SubChain> iterator, String ... entityCodes) {
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        SubChain subChain = iterator.next();
        List entityList = subChain.getEntityList();
        String message = "Expected entityCodes (" + Arrays.toString(entityCodes) + ") but received entityList (" + entityList + ").";
        PlannerAssert.assertEquals((String)message, (long)entityCodes.length, (long)entityList.size());
        for (int i = 0; i < entityCodes.length; ++i) {
            PlannerAssert.assertCode(message, entityCodes[i], entityList.get(i));
        }
    }
}

