/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.comparator.NaturalScoreComparator;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.ShiftingHardPenaltyDeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.comparator.FlatteningHardSoftScoreComparator;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ShiftingHardPenaltyDeciderScoreComparatorFactoryTest {
    @Test
    public void shiftingPenaltyActiveAndHardWeight() {
        ShiftingHardPenaltyDeciderScoreComparatorFactory deciderScoreComparatorFactory = new ShiftingHardPenaltyDeciderScoreComparatorFactory();
        deciderScoreComparatorFactory.setHardScoreActivationThreshold(-10);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMinimum(1);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMaximum(3);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeRepetitionMultiplicand(5.0);
        deciderScoreComparatorFactory.setHardWeightSurvivalRatio(0.9);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        deciderScoreComparatorFactory.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = localSearchSolverPhaseScope.getLastCompletedStepScope();
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        localSearchSolverPhaseScope.setBestSolutionStepIndex(localSearchStepScope.getStepIndex());
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertEquals((long)1000L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertEquals((long)900L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertEquals((long)810L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
        localSearchStepScope = this.nextStepScope(localSearchStepScope);
        deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        Assert.assertEquals((long)1000L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        localSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
    }

    private LocalSearchStepScope nextStepScope(LocalSearchStepScope lastLocalSearchStepScope) {
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(lastLocalSearchStepScope.getPhaseScope());
        lastLocalSearchStepScope.getPhaseScope().setLastCompletedStepScope(lastLocalSearchStepScope);
        localSearchStepScope.setStepIndex(lastLocalSearchStepScope.getStepIndex() + 1);
        return localSearchStepScope;
    }

    private LocalSearchSolverPhaseScope createLocalSearchSolverPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = new LocalSearchSolverPhaseScope(solverScope);
        solverScope.setBestScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        localSearchSolverPhaseScope.setBestSolutionStepIndex(1000);
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        lastLocalSearchStepScope.setStepIndex(1000);
        lastLocalSearchStepScope.setScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        localSearchSolverPhaseScope.setLastCompletedStepScope(lastLocalSearchStepScope);
        return localSearchSolverPhaseScope;
    }
}

