/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.placer.value;

import java.util.Iterator;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.constructionheuristic.placer.AbstractPlacer;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicSolverPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.termination.Termination;

public class ValuePlacer
extends AbstractPlacer {
    protected final Termination termination;
    protected final ValueSelector valueSelector;
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final int selectedCountLimit;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public ValuePlacer(Termination termination, ValueSelector valueSelector, int selectedCountLimit) {
        this.termination = termination;
        this.valueSelector = valueSelector;
        this.variableDescriptor = valueSelector.getVariableDescriptor();
        this.selectedCountLimit = selectedCountLimit;
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
        if (valueSelector.isNeverEnding() && selectedCountLimit == Integer.MAX_VALUE) {
            throw new IllegalStateException("The placer (" + this + ") with selectedCountLimit (" + selectedCountLimit + ") has valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
        }
    }

    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public ConstructionHeuristicMoveScope nominateMove(ConstructionHeuristicStepScope stepScope) {
        Object entity = stepScope.getEntity();
        if (this.variableDescriptor.isInitialized(entity)) {
            return null;
        }
        Score maxScore = null;
        ConstructionHeuristicMoveScope nominatedMoveScope = null;
        int moveIndex = 0;
        Iterator<Object> it = this.valueSelector.iterator(entity);
        while (it.hasNext()) {
            Object value = it.next();
            ConstructionHeuristicMoveScope moveScope = new ConstructionHeuristicMoveScope(stepScope);
            moveScope.setMoveIndex(moveIndex);
            ChangeMove move = this.variableDescriptor.isChained() ? new ChainedChangeMove(entity, this.variableDescriptor, value) : new ChangeMove(entity, this.variableDescriptor, value);
            moveScope.setMove(move);
            if (!move.isMoveDoable(stepScope.getScoreDirector())) {
                this.logger.trace("        Move index ({}) not doable, ignoring move ({}).", (Object)moveScope.getMoveIndex(), (Object)move);
            } else {
                this.doMove(moveScope);
                if (maxScore == null || moveScope.getScore().compareTo(maxScore) > 0) {
                    maxScore = moveScope.getScore();
                    nominatedMoveScope = moveScope;
                }
                if (moveIndex >= this.selectedCountLimit) break;
            }
            ++moveIndex;
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        return nominatedMoveScope;
    }

    private void doMove(ConstructionHeuristicMoveScope moveScope) {
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertUndoMoveIsUncorrupted) {
            ConstructionHeuristicSolverPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
            phaseScope.assertUndoMoveIsUncorrupted(move, undoMove);
        }
        this.logger.trace("        Move index ({}), score ({}) for move ({}).", new Object[]{moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getMove()});
    }

    private void processMove(ConstructionHeuristicMoveScope moveScope) {
        Score score = moveScope.getStepScope().getPhaseScope().calculateScore();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getStepScope().getPhaseScope().assertWorkingScoreFromScratch(score);
        }
        moveScope.setScore(score);
    }
}

