/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;

public class SubChainChangeMoveTest {
    @Test
    public void noTrailing() {
        PlanningEntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getPlanningVariableDescriptor("chainedObject");
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainChangeMove move = new SubChainChangeMove(new SubChain(Arrays.asList(a3, a4, a5)), variableDescriptor, (Object)b1);
        Move undoMove = move.createUndoMove(scoreDirector);
        move.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2);
        SelectorTestUtils.assertChain(b0, b1, a3, a4, a5);
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a5, "chainedObject");
        undoMove.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void oldAndNewTrailing() {
        PlanningEntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getPlanningVariableDescriptor("chainedObject");
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainChangeMove move = new SubChainChangeMove(new SubChain(Arrays.asList(a2, a3, a4)), variableDescriptor, (Object)b0);
        Move undoMove = move.createUndoMove(scoreDirector);
        move.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a5);
        SelectorTestUtils.assertChain(b0, a2, a3, a4, b1);
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)b1, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)b1, "chainedObject");
        undoMove.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }
}

