/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NativeFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;

public class SerializationTestUtils {
    public static <T> void serializeAndDeserializeWithAll(T input, OutputAsserter<T> outputAsserter) {
        outputAsserter.assertOutput(SerializationTestUtils.serializeAndDeserializeWithJavaSerialization(input));
        outputAsserter.assertOutput(SerializationTestUtils.serializeAndDeserializeWithXStream(input));
    }

    public static <T> T serializeAndDeserializeWithJavaSerialization(T input) {
        byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)input));
        return (T)SerializationUtils.deserialize((byte[])bytes);
    }

    public static <T> T serializeAndDeserializeWithXStream(T input) {
        XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new NativeFieldKeySorter())));
        xStream.setMode(1002);
        String xmlString = xStream.toXML(input);
        return (T)xStream.fromXML(xmlString);
    }

    private SerializationTestUtils() {
    }

    public static interface OutputAsserter<T> {
        public void assertOutput(T var1);
    }
}

