/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.lateannealing;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.ScoreUtils;

public class LateAnnealingAcceptor
extends AbstractAcceptor {
    protected int lateAnnealingSize = -1;
    protected boolean hillClimbingEnabled = true;
    protected Score[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAnnealingSize(int lateAnnealingSize) {
        this.lateAnnealingSize = lateAnnealingSize;
    }

    public void setHillClimbingEnabled(boolean hillClimbingEnabled) {
        this.hillClimbingEnabled = hillClimbingEnabled;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAnnealingSize];
        Score initialScore = phaseScope.getBestScore();
        for (int i = 0; i < this.previousScores.length; ++i) {
            this.previousScores[i] = initialScore;
        }
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateAnnealingSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (" + this.lateAnnealingSize + ") cannot be negative or zero.");
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        Score lastStepScore;
        Score score = moveScope.getScore();
        if (score.compareTo(lastStepScore = moveScope.getStepScope().getPhaseScope().getLastCompletedStepScope().getScore()) >= 0) {
            return true;
        }
        Score lateScore = this.previousScores[this.lateScoreIndex];
        Score scoreDifference = lastStepScore.subtract(score);
        double[] scoreDifferenceLevels = ScoreUtils.extractLevelDoubles(scoreDifference);
        Score lateScoreDifference = lastStepScore.subtract(lateScore);
        double[] lateScoreDifferenceLevels = ScoreUtils.extractLevelDoubles(lateScoreDifference);
        double acceptChance = 1.0;
        for (int i = 0; i < scoreDifferenceLevels.length; ++i) {
            double scoreDifferenceLevel = scoreDifferenceLevels[i];
            double lateScoreDifferenceLevel = lateScoreDifferenceLevels[i];
            double acceptChanceLevel = scoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-scoreDifferenceLevel / lateScoreDifferenceLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.previousScores[this.lateScoreIndex] = stepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAnnealingSize;
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }
}

