/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftdouble;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;

public class HardSoftDoubleScoreDefinition
extends AbstractScoreDefinition<HardSoftDoubleScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardSoftDoubleScore perfectMaximumScore = HardSoftDoubleScore.valueOf(0.0, 0.0);
    private HardSoftDoubleScore perfectMinimumScore = HardSoftDoubleScore.valueOf(-1.7976931348623157E308, -1.7976931348623157E308);

    public double getHardScoreTimeGradientWeight() {
        return this.hardScoreTimeGradientWeight;
    }

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public HardSoftDoubleScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(HardSoftDoubleScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public HardSoftDoubleScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(HardSoftDoubleScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<HardSoftDoubleScore> getScoreClass() {
        return HardSoftDoubleScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return HardSoftDoubleScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardSoftDoubleScore startScore, HardSoftDoubleScore endScore, HardSoftDoubleScore score) {
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
        if (startScore.getHardScore() == endScore.getHardScore()) {
            timeGradient += this.hardScoreTimeGradientWeight;
        } else {
            double hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            double hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = hardScoreDelta / hardScoreTotal;
            timeGradient += hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (!(score.getSoftScore() <= startScore.getSoftScore())) {
            double softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            double softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = softScoreDelta / softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardSoftDoubleScoreHolder(constraintMatchEnabled);
    }
}

