/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.FixedSelectorProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.UnionMoveSelector;
import org.optaplanner.core.impl.move.DummyMove;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class UnionMoveSelectorTest {
    @Test
    public void originSelection() {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        UnionMoveSelector moveSelector = new UnionMoveSelector(childMoveSelectorList, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3", "b1", "b2");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void randomSelection() {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        HashMap fixedProbabilityWeightMap = new HashMap();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3")));
        fixedProbabilityWeightMap.put(childMoveSelectorList.get(0), 1000.0);
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        fixedProbabilityWeightMap.put(childMoveSelectorList.get(1), 20.0);
        UnionMoveSelector moveSelector = new UnionMoveSelector(childMoveSelectorList, true, (SelectionProbabilityWeightFactory)new FixedSelectorProbabilityWeightFactory(fixedProbabilityWeightMap));
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)9.80392156862745E-4, (Object[])new Double[]{0.9990196078431373, 0.9803921568627451, 0.0, 0.9794117647058823});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a1", "b1", "b2", "a2", "a3");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }
}

