/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.CachingMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.FilteringMoveSelector;
import org.optaplanner.core.impl.move.DummyMove;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class FilteringMoveSelectorTest {
    @Test
    public void cacheTypeSolver() {
        this.runCacheType(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void cacheTypePhase() {
        this.runCacheType(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void cacheTypeStep() {
        this.runCacheType(SelectionCacheType.STEP, 5);
    }

    @Test
    public void cacheTypeJustInTime() {
        this.runCacheType(SelectionCacheType.JUST_IN_TIME, 5);
    }

    public void runCacheType(SelectionCacheType cacheType, int timesCalled) {
        MoveSelector childMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("e1"), new DummyMove("e2"), new DummyMove("e3"), new DummyMove("e4"));
        SelectionFilter<DummyMove> filter = new SelectionFilter<DummyMove>(){

            public boolean accept(ScoreDirector scoreDirector, DummyMove move) {
                return !move.getCode().equals("e3");
            }
        };
        List<SelectionFilter> filterList = Arrays.asList(filter);
        FilteringMoveSelector moveSelector = new FilteringMoveSelector(childMoveSelector, filterList);
        if (cacheType.isCached()) {
            moveSelector = new CachingMoveSelector((MoveSelector)moveSelector, cacheType, false);
        }
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, cacheType.isNotCached() ? 4L : 3L, "e1", "e2", "e4");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, cacheType.isNotCached() ? 4L : 3L, "e1", "e2", "e4");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, cacheType.isNotCached() ? 4L : 3L, "e1", "e2", "e4");
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, cacheType.isNotCached() ? 4L : 3L, "e1", "e2", "e4");
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, cacheType.isNotCached() ? 4L : 3L, "e1", "e2", "e4");
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelector, 1, 2, 5);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }
}

