/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class InitializedValueSelectorTest {
    @Test
    public void originalSelection() {
        PlanningEntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("chainedObject");
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1");
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelector(variableDescriptor, a0, a1, a2);
        InitializedValueSelector valueSelector = new InitializedValueSelector(variableDescriptor, childValueSelector);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        this.runAsserts((ValueSelector)valueSelector, a1, "a0");
        a1.setChainedObject(a0);
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        this.runAsserts((ValueSelector)valueSelector, a2, "a0", "a1");
        a2.setChainedObject(a1);
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        this.runAsserts((ValueSelector)valueSelector, a1, "a0", "a1", "a2");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        this.runAsserts((ValueSelector)valueSelector, a2, "a0", "a1", "a2");
        valueSelector.stepEnded(stepScopeB2);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 4);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)4))).iterator(Mockito.any());
    }

    private void runAsserts(ValueSelector valueSelector, TestdataChainedEntity entity, String ... valueCodes) {
        Iterator iterator = valueSelector.iterator((Object)entity);
        Assert.assertNotNull((Object)iterator);
        for (String valueCode : valueCodes) {
            Assert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(valueCode, iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)valueSelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
    }
}

