/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.greedyFit.decider;

import java.util.Iterator;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.GreedyMoveScope;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.forager.GreedyForager;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.scope.GreedyFitSolverPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.scope.GreedyFitStepScope;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningVariableWalker;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGreedyDecider
implements GreedyDecider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private PlanningVariableWalker planningVariableWalker;
    private GreedyForager forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public void setPlanningVariableWalker(PlanningVariableWalker planningVariableWalker) {
        this.planningVariableWalker = planningVariableWalker;
    }

    public void setForager(GreedyForager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void phaseStarted(GreedyFitSolverPhaseScope phaseScope) {
        this.planningVariableWalker.phaseStarted(phaseScope);
        this.forager.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(GreedyFitStepScope stepScope) {
        this.planningVariableWalker.stepStarted(stepScope);
        this.forager.stepStarted(stepScope);
    }

    @Override
    public void decideNextStep(GreedyFitStepScope stepScope) {
        GreedyMoveScope pickedMoveScope;
        Object planningEntity = stepScope.getPlanningEntity();
        int moveIndex = 0;
        Iterator<Move> moveIterator = this.planningVariableWalker.moveIterator(planningEntity);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            GreedyMoveScope moveScope = new GreedyMoveScope(stepScope);
            moveScope.setMoveIndex(moveIndex);
            moveScope.setMove(move);
            if (move.isMoveDoable(stepScope.getScoreDirector())) {
                this.doMove(moveScope);
                if (this.forager.isQuitEarly()) {
                    break;
                }
            } else {
                this.logger.trace("        Move index ({}) not doable, ignoring move ({}).", (Object)moveScope.getMoveIndex(), (Object)move);
            }
            ++moveIndex;
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(GreedyMoveScope moveScope) {
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore) {
            GreedyFitSolverPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
            phaseScope.assertExpectedUndoMoveScore(move, undoMove);
        }
        this.logger.trace("        Move index ({}), score ({}) for move ({}).", new Object[]{moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getMove()});
    }

    private void processMove(GreedyMoveScope moveScope) {
        Score score = moveScope.getStepScope().getPhaseScope().calculateScore();
        if (this.assertMoveScoreFromScratch) {
            moveScope.getStepScope().getPhaseScope().assertWorkingScoreFromScratch(score, moveScope.getMove());
        }
        moveScope.setScore(score);
        this.forager.addMove(moveScope);
    }

    @Override
    public void stepEnded(GreedyFitStepScope stepScope) {
        this.planningVariableWalker.stepEnded(stepScope);
        this.forager.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(GreedyFitSolverPhaseScope phaseScope) {
        this.planningVariableWalker.phaseEnded(phaseScope);
        this.forager.phaseEnded(phaseScope);
    }
}

