/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.shadow;

import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.AbstractPlanningVariableListener;
import org.optaplanner.core.impl.domain.variable.shadow.ShadowVariableDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedMappedByVariableListener
extends AbstractPlanningVariableListener<Object> {
    private final ShadowVariableDescriptor shadowVariableDescriptor;
    private final PlanningVariableDescriptor mappedByVariableDescriptor;

    public ChainedMappedByVariableListener(ShadowVariableDescriptor shadowVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.mappedByVariableDescriptor = shadowVariableDescriptor.getMappedByVariableDescriptor();
    }

    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, Object entity) {
    }

    protected void insert(ScoreDirector scoreDirector, Object entity) {
        Object shadowEntity = this.mappedByVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (shadowValue != null) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.mappedByVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a mappedBy variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowValue + ") which is not null.\n" + "Verify the consistency of your input problem for that mappedBy variable.");
            }
            scoreDirector.beforeVariableChanged(entity, this.shadowVariableDescriptor.getVariableName());
            this.shadowVariableDescriptor.setValue(shadowEntity, entity);
            scoreDirector.afterVariableChanged(entity, this.shadowVariableDescriptor.getVariableName());
        }
    }

    protected void retract(ScoreDirector scoreDirector, Object entity) {
        Object shadowEntity = this.mappedByVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (shadowValue != entity) {
                throw new IllegalStateException("The entity (" + entity + ") has a variable (" + this.mappedByVariableDescriptor.getVariableName() + ") with value (" + shadowEntity + ") which has a mappedBy variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + shadowValue + ") which is not that entity.\n" + "Verify the consistency of your input problem for that mappedBy variable.");
            }
            scoreDirector.beforeVariableChanged(entity, this.shadowVariableDescriptor.getVariableName());
            this.shadowVariableDescriptor.setValue(shadowEntity, null);
            scoreDirector.afterVariableChanged(entity, this.shadowVariableDescriptor.getVariableName());
        }
    }
}

