/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.ListIterable;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarSwapMove;
import org.optaplanner.core.impl.move.Move;

public class PillarSwapMoveSelector
extends GenericMoveSelector {
    protected final PillarSelector leftPillarSelector;
    protected final PillarSelector rightPillarSelector;
    protected final Collection<PlanningVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;

    public PillarSwapMoveSelector(PillarSelector leftPillarSelector, PillarSelector rightPillarSelector, Collection<PlanningVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.leftPillarSelector = leftPillarSelector;
        this.rightPillarSelector = rightPillarSelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        Class<?> leftEntityClass = leftPillarSelector.getEntityDescriptor().getPlanningEntityClass();
        if (!leftEntityClass.equals(rightPillarSelector.getEntityDescriptor().getPlanningEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a leftPillarSelector's entityClass (" + leftEntityClass + ") which is not equal to the rightPillarSelector's entityClass (" + rightPillarSelector.getEntityDescriptor().getPlanningEntityClass() + ").");
        }
        if (variableDescriptors.isEmpty()) {
            throw new IllegalStateException("The selector (" + this + ")'s variableDescriptors (" + variableDescriptors + ") is empty.");
        }
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!leftEntityClass.equals(variableDescriptor.getEntityDescriptor().getPlanningEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a entityClass (" + variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") which is not equal to the leftPillarSelector's entityClass (" + leftEntityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(leftPillarSelector);
        if (leftPillarSelector != rightPillarSelector) {
            this.solverPhaseLifecycleSupport.addEventListener(rightPillarSelector);
        }
    }

    @Override
    public boolean isContinuous() {
        return this.leftPillarSelector.isContinuous() || this.rightPillarSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftPillarSelector.isNeverEnding() || this.rightPillarSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftPillarSelector, this.rightPillarSelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, List<Object>>((ListIterable)this.leftPillarSelector, (ListIterable)this.rightPillarSelector){

                @Override
                protected Move newSwapSelection(List<Object> leftSubSelection, List<Object> rightSubSelection) {
                    return new PillarSwapMove(PillarSwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, List<Object>>((Iterable)this.leftPillarSelector, (Iterable)this.rightPillarSelector){

            @Override
            protected Move newSwapSelection(List<Object> leftSubSelection, List<Object> rightSubSelection) {
                return new PillarSwapMove(PillarSwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftPillarSelector + ", " + this.rightPillarSelector + ")";
    }
}

