/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.util.RandomUtils;

public class DefaultSubChainSelector
extends AbstractSelector
implements SubChainSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntityIndependentValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final int minimumSubChainSize;
    protected final int maximumSubChainSize;
    protected List<SubChain> anchorTrailingChainList = null;

    public DefaultSubChainSelector(EntityIndependentValueSelector valueSelector, boolean randomSelection, int minimumSubChainSize, int maximumSubChainSize) {
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.minimumSubChainSize = minimumSubChainSize;
        this.maximumSubChainSize = maximumSubChainSize;
        if (!valueSelector.getVariableDescriptor().isChained()) {
            throw new IllegalArgumentException("The selector (" + this + ")'s valueSelector (" + valueSelector + ") must have a chained variableDescriptor chained (" + valueSelector.getVariableDescriptor().isChained() + ").");
        }
        if (valueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        if (minimumSubChainSize < 1) {
            throw new IllegalStateException("The selector (" + this + ")'s minimumSubChainSize (" + minimumSubChainSize + ") must be at least 1.");
        }
        if (minimumSubChainSize > maximumSubChainSize) {
            throw new IllegalStateException("The minimumSubChainSize (" + minimumSubChainSize + ") must be at least maximumSubChainSize (" + maximumSubChainSize + ").");
        }
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.valueSelector.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        ScoreDirector scoreDirector = solverScope.getScoreDirector();
        PlanningVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        Class<?> entityClass = variableDescriptor.getEntityDescriptor().getPlanningEntityClass();
        long valueSize = this.valueSelector.getSize();
        if (valueSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + this.valueSelector + ") with valueSize (" + valueSize + ") which is higher than Integer.MAX_VALUE.");
        }
        LinkedList anchorList = new LinkedList();
        for (Object value : this.valueSelector) {
            if (entityClass.isAssignableFrom(value.getClass())) continue;
            anchorList.add(value);
        }
        this.anchorTrailingChainList = new ArrayList<SubChain>(anchorList.size());
        int anchorChainInitialCapacity = (int)valueSize / anchorList.size() + 1;
        for (Object anchor : anchorList) {
            ArrayList<Object> anchorChain = new ArrayList<Object>(anchorChainInitialCapacity);
            Object trailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, anchor);
            while (trailingEntity != null) {
                anchorChain.add(trailingEntity);
                trailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, trailingEntity);
            }
            if (anchorChain.size() < this.minimumSubChainSize) continue;
            this.anchorTrailingChainList.add(new SubChain(anchorChain));
        }
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.anchorTrailingChainList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long selectionSize = 0L;
        for (SubChain anchorTrailingChain : this.anchorTrailingChainList) {
            selectionSize += this.calculateSubChainSelectionSize(anchorTrailingChain);
        }
        return selectionSize;
    }

    private long calculateSubChainSelectionSize(SubChain anchorTrailingChain) {
        long anchorTrailingChainSize = anchorTrailingChain.getSize();
        long n = anchorTrailingChainSize - (long)this.minimumSubChainSize + 1L;
        long m = (long)this.maximumSubChainSize >= anchorTrailingChainSize ? 0L : anchorTrailingChainSize - (long)this.maximumSubChainSize;
        return n * (n + 1L) / 2L - m * (m + 1L) / 2L;
    }

    @Override
    public Iterator<SubChain> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.iterator());
        }
        return new RandomSubChainIterator();
    }

    @Override
    public ListIterator<SubChain> listIterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.iterator());
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<SubChain> listIterator(int index) {
        if (!this.randomSelection) {
            OriginalSubChainIterator it = new OriginalSubChainIterator(this.anchorTrailingChainList.iterator());
            for (int i = 0; i < index; ++i) {
                it.next();
            }
            return it;
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelector + ")";
    }

    private class RandomSubChainIterator
    extends UpcomingSelectionIterator<SubChain> {
        private RandomSubChainIterator() {
            if (DefaultSubChainSelector.this.anchorTrailingChainList.isEmpty()) {
                this.upcomingSelection = null;
            } else {
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            long selectionIndex;
            SubChain anchorTrailingChain = this.selectAnchorTrailingChain();
            long selectionSize = DefaultSubChainSelector.this.calculateSubChainSelectionSize(anchorTrailingChain);
            long fromIndex = selectionIndex = RandomUtils.nextLong(DefaultSubChainSelector.this.workingRandom, selectionSize);
            long subChainSize = DefaultSubChainSelector.this.minimumSubChainSize;
            long countInThatSize = (long)anchorTrailingChain.getSize() - subChainSize + 1L;
            while (fromIndex >= countInThatSize) {
                fromIndex -= countInThatSize;
                ++subChainSize;
                if (--countInThatSize > 0L) continue;
                throw new IllegalStateException("Impossible if calculateSubChainSelectionSize() works correctly.");
            }
            this.upcomingSelection = anchorTrailingChain.subChain((int)fromIndex, (int)(fromIndex + subChainSize));
        }

        private SubChain selectAnchorTrailingChain() {
            int anchorTrailingChainListIndex = DefaultSubChainSelector.this.workingRandom.nextInt(DefaultSubChainSelector.this.anchorTrailingChainList.size());
            return DefaultSubChainSelector.this.anchorTrailingChainList.get(anchorTrailingChainListIndex);
        }
    }

    private class OriginalSubChainIterator
    extends UpcomingSelectionIterator<SubChain>
    implements ListIterator<SubChain> {
        private final Iterator<SubChain> anchorTrailingChainIterator;
        private List<Object> anchorTrailingChain;
        private int fromIndex;
        private int toIndex;
        private int nextListIteratorIndex;

        public OriginalSubChainIterator(Iterator<SubChain> anchorTrailingChainIterator) {
            this.anchorTrailingChainIterator = anchorTrailingChainIterator;
            this.fromIndex = 0;
            this.toIndex = 1;
            this.anchorTrailingChain = Collections.emptyList();
            this.nextListIteratorIndex = 0;
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            ++this.toIndex;
            if (this.toIndex - this.fromIndex > DefaultSubChainSelector.this.maximumSubChainSize || this.toIndex > this.anchorTrailingChain.size()) {
                ++this.fromIndex;
                this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                while (this.toIndex > this.anchorTrailingChain.size()) {
                    if (!this.anchorTrailingChainIterator.hasNext()) {
                        this.upcomingSelection = null;
                        return;
                    }
                    this.anchorTrailingChain = this.anchorTrailingChainIterator.next().getEntityList();
                    this.fromIndex = 0;
                    this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                }
            }
            this.upcomingSelection = new SubChain(this.anchorTrailingChain.subList(this.fromIndex, this.toIndex));
        }

        @Override
        public SubChain next() {
            ++this.nextListIteratorIndex;
            return (SubChain)super.next();
        }

        @Override
        public int nextIndex() {
            return this.nextListIteratorIndex;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException("The operation hasPrevious() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public SubChain previous() {
            throw new UnsupportedOperationException("The operation previous() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException("The operation previousIndex() is not supported. See https://issues.jboss.org/browse/PLANNER-37");
        }

        @Override
        public void set(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation set() is not supported.");
        }

        @Override
        public void add(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation add() is not supported.");
        }
    }
}

