/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;

public class InitializedValueSelector
extends AbstractValueSelector {
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final ValueSelector childValueSelector;
    protected final boolean bailOutEnabled;

    public InitializedValueSelector(PlanningVariableDescriptor variableDescriptor, ValueSelector childValueSelector) {
        this.variableDescriptor = variableDescriptor;
        this.childValueSelector = childValueSelector;
        this.bailOutEnabled = childValueSelector.isNeverEnding();
        this.solverPhaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return this.childValueSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new JustInTimeInitializedValueIterator(entity, this.childValueSelector.iterator(entity));
    }

    protected long determineBailOutSize(Object entity) {
        return this.childValueSelector.getSize(entity) * 10L;
    }

    private boolean accept(Object value) {
        return value == null || !this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass().isAssignableFrom(value.getClass()) || this.variableDescriptor.isInitialized(value);
    }

    public String toString() {
        return "Initialized(" + this.childValueSelector + ")";
    }

    private class JustInTimeInitializedValueIterator
    extends UpcomingSelectionIterator<Object> {
        private final Object entity;
        private final Iterator<Object> childValueIterator;

        public JustInTimeInitializedValueIterator(Object entity, Iterator<Object> childValueIterator) {
            this.entity = entity;
            this.childValueIterator = childValueIterator;
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut;
            long l = attemptsBeforeBailOut = InitializedValueSelector.this.bailOutEnabled ? InitializedValueSelector.this.determineBailOutSize(this.entity) : 0L;
            do {
                if (!this.childValueIterator.hasNext()) {
                    next = null;
                    break;
                }
                if (!InitializedValueSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    InitializedValueSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)InitializedValueSelector.this);
                    next = null;
                    break;
                }
                --attemptsBeforeBailOut;
            } while (!InitializedValueSelector.this.accept(next = this.childValueIterator.next()));
            this.upcomingSelection = next;
        }
    }
}

