/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.localsearch.LocalSearchSolverPhase;
import org.optaplanner.core.impl.localsearch.decider.Decider;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.forager.Forager;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolverPhase localSearchSolverPhase;
    protected Termination termination;
    protected MoveSelector moveSelector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    @Override
    public void setLocalSearchSolverPhase(LocalSearchSolverPhase localSearchSolverPhase) {
        this.localSearchSolverPhase = localSearchSolverPhase;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setMoveSelector(MoveSelector moveSelector) {
        this.moveSelector = moveSelector;
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Override
    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.moveSelector.solvingStarted(solverScope);
        this.acceptor.solvingStarted(solverScope);
        this.forager.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        this.moveSelector.phaseStarted(phaseScope);
        this.acceptor.phaseStarted(phaseScope);
        this.forager.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        this.moveSelector.stepStarted(stepScope);
        this.acceptor.stepStarted(stepScope);
        this.forager.stepStarted(stepScope);
    }

    @Override
    public void decideNextStep(LocalSearchStepScope stepScope) {
        LocalSearchMoveScope pickedMoveScope;
        ScoreDirector scoreDirector = stepScope.getScoreDirector();
        int moveIndex = 0;
        for (Move move : this.moveSelector) {
            LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
            moveScope.setMoveIndex(moveIndex);
            moveScope.setMove(move);
            if (!move.isMoveDoable(scoreDirector)) {
                this.logger.trace("        Move index ({}) not doable, ignoring move ({}).", (Object)moveScope.getMoveIndex(), (Object)move);
            } else {
                this.doMove(moveScope);
                if (this.forager.isQuitEarly()) break;
            }
            ++moveIndex;
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(LocalSearchMoveScope moveScope) {
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore) {
            LocalSearchSolverPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
            phaseScope.assertExpectedUndoMoveScore(move, undoMove);
        }
        this.logger.trace("        Move index ({}), score ({}), accepted ({}) for move ({}).", new Object[]{moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getAccepted(), moveScope.getMove()});
    }

    private void processMove(LocalSearchMoveScope moveScope) {
        Score score = moveScope.getStepScope().getPhaseScope().calculateScore();
        if (this.assertMoveScoreFromScratch) {
            moveScope.getStepScope().getPhaseScope().assertWorkingScoreFromScratch(score, moveScope.getMove());
        }
        moveScope.setScore(score);
        boolean accepted = this.acceptor.isAccepted(moveScope);
        moveScope.setAccepted(accepted);
        this.forager.addMove(moveScope);
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        this.moveSelector.stepEnded(stepScope);
        this.acceptor.stepEnded(stepScope);
        this.forager.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        this.moveSelector.phaseEnded(phaseScope);
        this.acceptor.phaseEnded(phaseScope);
        this.forager.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.moveSelector.solvingEnded(solverScope);
        this.acceptor.solvingEnded(solverScope);
        this.forager.solvingEnded(solverScope);
    }
}

