/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.mutation;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.solution.mutation.MutationCounter;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;

public class MutationCounterTest {
    @Test
    public void countMutationsNone() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        MutationCounter mutationCounter = new MutationCounter(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        TestdataEntity a_a = new TestdataEntity("a", val1);
        TestdataEntity a_b = new TestdataEntity("b", val1);
        TestdataEntity a_c = new TestdataEntity("c", val3);
        TestdataEntity a_d = new TestdataEntity("d", val3);
        List<TestdataEntity> aEntityList = Arrays.asList(a_a, a_b, a_c, a_d);
        TestdataSolution a = new TestdataSolution("solution");
        a.setValueList(valueList);
        a.setEntityList(aEntityList);
        TestdataEntity b_a = new TestdataEntity("a", val1);
        TestdataEntity b_b = new TestdataEntity("b", val1);
        TestdataEntity b_c = new TestdataEntity("c", val3);
        TestdataEntity b_d = new TestdataEntity("d", val3);
        List<TestdataEntity> bEntityList = Arrays.asList(b_a, b_b, b_c, b_d);
        TestdataSolution b = new TestdataSolution("solution");
        b.setValueList(valueList);
        b.setEntityList(bEntityList);
        Assert.assertEquals((long)0L, (long)mutationCounter.countMutations((Solution)a, (Solution)b));
    }

    @Test
    public void countMutationsSome() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        MutationCounter mutationCounter = new MutationCounter(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        TestdataEntity a_a = new TestdataEntity("a", val1);
        TestdataEntity a_b = new TestdataEntity("b", val1);
        TestdataEntity a_c = new TestdataEntity("c", val3);
        TestdataEntity a_d = new TestdataEntity("d", val3);
        List<TestdataEntity> aEntityList = Arrays.asList(a_a, a_b, a_c, a_d);
        TestdataSolution a = new TestdataSolution("solution");
        a.setValueList(valueList);
        a.setEntityList(aEntityList);
        TestdataEntity b_a = new TestdataEntity("a", val3);
        TestdataEntity b_b = new TestdataEntity("b", val1);
        TestdataEntity b_c = new TestdataEntity("c", val3);
        TestdataEntity b_d = new TestdataEntity("d", val2);
        List<TestdataEntity> bEntityList = Arrays.asList(b_a, b_b, b_c, b_d);
        TestdataSolution b = new TestdataSolution("solution");
        b.setValueList(valueList);
        b.setEntityList(bEntityList);
        Assert.assertEquals((long)2L, (long)mutationCounter.countMutations((Solution)a, (Solution)b));
    }

    @Test
    public void countMutationsAll() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        MutationCounter mutationCounter = new MutationCounter(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        TestdataEntity a_a = new TestdataEntity("a", val1);
        TestdataEntity a_b = new TestdataEntity("b", val1);
        TestdataEntity a_c = new TestdataEntity("c", val3);
        TestdataEntity a_d = new TestdataEntity("d", val3);
        List<TestdataEntity> aEntityList = Arrays.asList(a_a, a_b, a_c, a_d);
        TestdataSolution a = new TestdataSolution("solution");
        a.setValueList(valueList);
        a.setEntityList(aEntityList);
        TestdataEntity b_a = new TestdataEntity("a", val2);
        TestdataEntity b_b = new TestdataEntity("b", val2);
        TestdataEntity b_c = new TestdataEntity("c", val2);
        TestdataEntity b_d = new TestdataEntity("d", val2);
        List<TestdataEntity> bEntityList = Arrays.asList(b_a, b_b, b_c, b_d);
        TestdataSolution b = new TestdataSolution("solution");
        b.setValueList(valueList);
        b.setEntityList(bEntityList);
        Assert.assertEquals((long)4L, (long)mutationCounter.countMutations((Solution)a, (Solution)b));
    }
}

