/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.CachingEntitySelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CachingEntitySelectorTest {
    @Test
    public void originalSelectionCacheTypeSolver() {
        this.runOriginalSelection(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void originalSelectionCacheTypePhase() {
        this.runOriginalSelection(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void originalSelectionCacheTypeStep() {
        this.runOriginalSelection(SelectionCacheType.STEP, 5);
    }

    public void runOriginalSelection(SelectionCacheType cacheType, int timesCalled) {
        EntitySelector childEntitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        CachingEntitySelector entitySelector = new CachingEntitySelector(childEntitySelector, cacheType, false);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA1);
        this.runAsserts(entitySelector);
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA2);
        this.runAsserts(entitySelector);
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB1);
        this.runAsserts(entitySelector);
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB2);
        this.runAsserts(entitySelector);
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB3);
        this.runAsserts(entitySelector);
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childEntitySelector, 1, 2, 5);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }

    private void runAsserts(CachingEntitySelector entitySelector) {
        Iterator iterator = entitySelector.iterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e1", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e2", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e3", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)entitySelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)entitySelector.getSize());
    }
}

