/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataMultiVarEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ReinitializeVariableValueSelectorTest {
    @Test
    public void oneVariable() {
        PlanningEntityDescriptor entityDescriptor = TestdataEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("value");
        TestdataEntity e1 = new TestdataEntity("e1");
        TestdataEntity e2 = new TestdataEntity("e2");
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataValue v3 = new TestdataValue("v3");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelector(variableDescriptor, v1, v2, v3);
        ReinitializeVariableValueSelector valueSelector = new ReinitializeVariableValueSelector(childValueSelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e1, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        e2.setValue(v2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e2, new String[0]);
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        e2.setValue(null);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e2, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        e1.setValue(v3);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e1, new String[0]);
        valueSelector.stepEnded(stepScopeB2);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 4);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.atMost((int)4))).iterator(Mockito.any());
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.atMost((int)4))).getSize(Mockito.any());
    }

    @Test
    public void multiVariable() {
        PlanningEntityDescriptor entityDescriptor = TestdataMultiVarEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("secondaryValue");
        TestdataMultiVarEntity e1 = new TestdataMultiVarEntity("e1");
        TestdataMultiVarEntity e2 = new TestdataMultiVarEntity("e2");
        TestdataValue p1 = new TestdataValue("p1");
        TestdataValue s1 = new TestdataValue("s1");
        TestdataValue s2 = new TestdataValue("s2");
        TestdataValue s3 = new TestdataValue("s3");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelector(variableDescriptor, s1, s2, s3);
        ReinitializeVariableValueSelector valueSelector = new ReinitializeVariableValueSelector(childValueSelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        e1.setPrimaryValue(p1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e1, "s1", "s2", "s3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        e2.setSecondaryValue(s2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e2, new String[0]);
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        e2.setSecondaryValue(null);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e2, "s1", "s2", "s3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        e1.setPrimaryValue(null);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e1, "s1", "s2", "s3");
        valueSelector.stepEnded(stepScopeB2);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 4);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.atMost((int)4))).iterator(Mockito.any());
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.atMost((int)4))).getSize(Mockito.any());
    }
}

