/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.util;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.CompositeMove;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.CodeAssertable;

public class PlannerAssert
extends Assert {
    public static final long DO_NOT_ASSERT_SIZE = Long.MIN_VALUE;

    public static void assertInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (!expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static void assertNotInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertNotInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertNotInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, "not " + expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static void verifySolverPhaseLifecycle(SolverPhaseLifecycleListener lifecycleListener, int solvingCount, int phaseCount, int stepCount) {
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingStarted((DefaultSolverScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseStarted((AbstractSolverPhaseScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepStarted((AbstractStepScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepEnded((AbstractStepScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseEnded((AbstractSolverPhaseScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingEnded((DefaultSolverScope)Matchers.any());
    }

    private static CodeAssertable convertToCodeAssertable(Object o) {
        PlannerAssert.assertNotNull((Object)o);
        if (o instanceof CodeAssertable) {
            return (CodeAssertable)o;
        }
        if (o instanceof ChangeMove) {
            ChangeMove changeMove = (ChangeMove)o;
            final String code = PlannerAssert.convertToCodeAssertable(changeMove.getEntity()).getCode() + "=>" + PlannerAssert.convertToCodeAssertable(changeMove.getToPlanningValue()).getCode();
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        if (o instanceof CompositeMove) {
            CompositeMove compositeMove = (CompositeMove)o;
            StringBuilder codeBuilder = new StringBuilder(compositeMove.getMoveList().size() * 80);
            for (Move move : compositeMove.getMoveList()) {
                codeBuilder.append("+").append(PlannerAssert.convertToCodeAssertable(move).getCode());
            }
            final String code = codeBuilder.substring(1);
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        throw new AssertionError((Object)("o's class (" + o.getClass() + ") cannot be converted to CodeAssertable."));
    }

    public static void assertCode(String expectedCode, Object o) {
        CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
        PlannerAssert.assertCode(expectedCode, codeAssertable);
    }

    public static void assertCode(String message, String expectedCode, Object o) {
        CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
        PlannerAssert.assertCode(message, expectedCode, codeAssertable);
    }

    public static void assertCode(String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static void assertCode(String message, String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((String)message, (Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static <O> void assertCodesOfIterator(Iterator<O> iterator, String ... codes) {
        PlannerAssert.assertNotNull(iterator);
        for (String code : codes) {
            PlannerAssert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(code, iterator.next());
        }
    }

    public static <O> void assertAllCodesOfIterator(Iterator<O> iterator, String ... codes) {
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
    }

    public static void assertAllCodesOfMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfMoveSelector(moveSelector, codes.length, codes);
    }

    public static void assertAllCodesOfMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(moveSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertCodesOfNeverEndingMoveSelector(moveSelector, codes.length, codes);
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertEmptyNeverEndingMoveSelector(MoveSelector moveSelector) {
        PlannerAssert.assertEmptyNeverEndingMoveSelector(moveSelector, 0L);
    }

    public static void assertEmptyNeverEndingMoveSelector(MoveSelector moveSelector, long size) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertAllCodesOfEntitySelector(EntitySelector entitySelector, String ... codes) {
        PlannerAssert.assertAllCodesOfEntitySelector(entitySelector, codes.length, codes);
    }

    public static void assertAllCodesOfEntitySelector(EntitySelector entitySelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(entitySelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)entitySelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)entitySelector.getSize());
        }
    }

    public static void assertAllCodesOfValueSelector(EntityIndependentValueSelector valueSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfValueSelector(valueSelector, codes.length, codes);
    }

    public static void assertAllCodesOfValueSelector(EntityIndependentValueSelector valueSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(valueSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)valueSelector.getSize());
        }
    }

    public static void assertAllCodesOfValueSelectorForEntity(ValueSelector valueSelector, Object entity, String ... codes) {
        PlannerAssert.assertAllCodesOfValueSelectorForEntity(valueSelector, entity, codes.length, codes);
    }

    public static void assertAllCodesOfValueSelectorForEntity(ValueSelector valueSelector, Object entity, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(valueSelector.iterator(entity), codes);
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)valueSelector.getSize(entity));
        }
    }

    private PlannerAssert() {
    }
}

