/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.SameValuePillarSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class SameValuePillarSelectorTest {
    @Test
    public void original() {
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataValue val4 = new TestdataValue("4");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val2);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val2);
        TestdataEntity e = new TestdataEntity("e", val3);
        TestdataEntity f = new TestdataEntity("f", val3);
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, a, b, c, d, e, f);
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entitySelector.getEntityDescriptor(), "value");
        for (final TestdataEntity entity : Arrays.asList(a, b, c, d, e, f)) {
            Mockito.when((Object)variableDescriptor.getValue((Object)entity)).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return entity.getValue();
                }
            });
        }
        SameValuePillarSelector pillarSelector = new SameValuePillarSelector(entitySelector, Arrays.asList(variableDescriptor), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        pillarSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        this.runAssertsOriginal1(pillarSelector);
        pillarSelector.stepEnded(stepScopeA1);
        b.setValue(val3);
        f.setValue(val4);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        this.runAssertsOriginal2(pillarSelector);
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        this.runAssertsOriginal2(pillarSelector);
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    private void runAssertsOriginal1(SameValuePillarSelector pillarSelector) {
        Iterator iterator = pillarSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextPillar(iterator, "a");
        this.assertNextPillar(iterator, "b", "d");
        this.assertNextPillar(iterator, "c", "e", "f");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)3L, (long)pillarSelector.getSize());
    }

    private void runAssertsOriginal2(SameValuePillarSelector pillarSelector) {
        Iterator iterator = pillarSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextPillar(iterator, "a");
        this.assertNextPillar(iterator, "b", "c", "e");
        this.assertNextPillar(iterator, "d");
        this.assertNextPillar(iterator, "f");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)4L, (long)pillarSelector.getSize());
    }

    @Test
    public void emptyEntitySelectorOriginal() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new Object[0]);
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entitySelector.getEntityDescriptor(), "value");
        SameValuePillarSelector pillarSelector = new SameValuePillarSelector(entitySelector, Arrays.asList(variableDescriptor), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        pillarSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyOriginal(pillarSelector);
        pillarSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyOriginal(pillarSelector);
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyOriginal(pillarSelector);
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    private void runAssertsEmptyOriginal(SameValuePillarSelector pillarSelector) {
        Iterator iterator = pillarSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)0L, (long)pillarSelector.getSize());
    }

    private void assertNextPillar(Iterator<List<Object>> iterator, String ... entityCodes) {
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        List<Object> pillar = iterator.next();
        String message = "Expected entityCodes (" + Arrays.toString(entityCodes) + ") but received pillar (" + pillar + ").";
        PlannerAssert.assertEquals((String)message, (long)entityCodes.length, (long)pillar.size());
        for (int i = 0; i < entityCodes.length; ++i) {
            PlannerAssert.assertCode(message, entityCodes[i], pillar.get(i));
        }
    }
}

