/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.Random;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.CachingMoveSelector;
import org.optaplanner.core.impl.move.DummyMove;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CachingMoveSelectorTest {
    @Test
    public void originalSelectionCacheTypeSolver() {
        this.runOriginalSelection(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void originalSelectionCacheTypePhase() {
        this.runOriginalSelection(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void originalSelectionCacheTypeStep() {
        this.runOriginalSelection(SelectionCacheType.STEP, 5);
    }

    public void runOriginalSelection(SelectionCacheType cacheType, int timesCalled) {
        MoveSelector childMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3"));
        CachingMoveSelector moveSelector = new CachingMoveSelector(childMoveSelector, cacheType, false);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelector, 1, 2, 5);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }

    @Test
    public void randomSelectionCacheTypeSolver() {
        this.runRandomSelection(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void randomSelectionCacheTypePhase() {
        this.runRandomSelection(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void randomSelectionCacheTypeStep() {
        this.runRandomSelection(SelectionCacheType.STEP, 3);
    }

    public void runRandomSelection(SelectionCacheType cacheType, int timesCalled) {
        MoveSelector childMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3"));
        CachingMoveSelector moveSelector = new CachingMoveSelector(childMoveSelector, cacheType, true);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        Random workingRandom = (Random)Mockito.mock(Random.class);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.stepStarted(stepScopeA1);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1, (Object[])new Integer[]{0, 2});
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, "a2", "a1", "a3");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.stepStarted(stepScopeA2);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)2, (Object[])new Integer[]{0, 1});
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, "a3", "a1", "a2");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.stepStarted(stepScopeB1);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1, (Object[])new Integer[]{2, 0});
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, "a2", "a3", "a1");
        moveSelector.stepEnded(stepScopeB1);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelector, 1, 2, 3);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }
}

