/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Iterator;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ChangeMoveSelectorTest {
    @Test
    public void original() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }

    private void runAssertsOriginal(ChangeMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextChangeMove(iterator, "a", "1");
        this.assertNextChangeMove(iterator, "a", "2");
        this.assertNextChangeMove(iterator, "a", "3");
        this.assertNextChangeMove(iterator, "b", "1");
        this.assertNextChangeMove(iterator, "b", "2");
        this.assertNextChangeMove(iterator, "b", "3");
        this.assertNextChangeMove(iterator, "c", "1");
        this.assertNextChangeMove(iterator, "c", "2");
        this.assertNextChangeMove(iterator, "c", "3");
        this.assertNextChangeMove(iterator, "d", "1");
        this.assertNextChangeMove(iterator, "d", "2");
        this.assertNextChangeMove(iterator, "d", "3");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)12L, (long)moveSelector.getSize());
    }

    @Test
    public void emptyEntitySelectorOriginal() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new Object[0]);
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }

    @Test
    public void emptyValueSelectorOriginal() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new Object[0]);
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsEmptyOriginal(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }

    private void runAssertsEmptyOriginal(ChangeMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)0L, (long)moveSelector.getSize());
    }

    private void assertNextChangeMove(Iterator<Move> iterator, String entityCode, String toValueCode) {
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        ChangeMove move = (ChangeMove)iterator.next();
        PlannerAssert.assertCode(entityCode, move.getEntity());
        PlannerAssert.assertCode(toValueCode, move.getToPlanningValue());
    }
}

