/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.CachingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.FilteringEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.SortingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;

@XStreamAlias(value="entitySelector")
public class EntitySelectorConfig
extends SelectorConfig {
    @XStreamAsAttribute
    protected String id = null;
    @XStreamAsAttribute
    protected String mimicSelectorRef = null;
    protected Class<?> entityClass = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamImplicit(itemFieldName="filterClass")
    protected List<Class<? extends SelectionFilter>> filterClassList = null;
    protected EntitySorterManner sorterManner = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public List<Class<? extends SelectionFilter>> getFilterClassList() {
        return this.filterClassList;
    }

    public void setFilterClassList(List<Class<? extends SelectionFilter>> filterClassList) {
        this.filterClassList = filterClassList;
    }

    public EntitySorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(EntitySorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    public Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public EntitySelector buildEntitySelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (this.mimicSelectorRef != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        PlanningEntityDescriptor entityDescriptor = this.deduceEntityDescriptor(configPolicy.getSolutionDescriptor(), this.entityClass);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        EntitySelector entitySelector = this.buildBaseEntitySelector(configPolicy, entityDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(entityDescriptor, resolvedCacheType, resolvedSelectionOrder));
        entitySelector = this.applyFiltering(entityDescriptor, resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyMimicRecording(configPolicy, entitySelector);
        return entitySelector;
    }

    protected EntitySelector buildMimicReplaying(HeuristicConfigPolicy configPolicy) {
        if (this.id != null || this.entityClass != null || this.cacheType != null || this.selectionOrder != null || this.filterClassList != null || this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null || this.probabilityWeightFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with mimicSelectorRef (" + this.mimicSelectorRef + ") has another property that is not null.");
        }
        MimicRecordingEntitySelector mimicRecordingEntitySelector = configPolicy.getMimicRecordingEntitySelector(this.mimicSelectorRef);
        if (mimicRecordingEntitySelector == null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has a mimicSelectorRef (" + this.mimicSelectorRef + ") for which no entitySelector with that id exists (in its solver phase).");
        }
        return new MimicReplayingEntitySelector(mimicRecordingEntitySelector);
    }

    protected boolean determineBaseRandomSelection(PlanningEntityDescriptor entityDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering(entityDescriptor);
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached() {
        return true;
    }

    private EntitySelector buildBaseEntitySelector(HeuristicConfigPolicy configPolicy, PlanningEntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + (Object)((Object)minimumCacheType) + ") is not yet supported. Please use " + (Object)((Object)SelectionCacheType.PHASE) + " instead.");
        }
        return new FromSolutionEntitySelector(entityDescriptor, minimumCacheType, randomSelection);
    }

    private boolean hasFiltering(PlanningEntityDescriptor entityDescriptor) {
        return !CollectionUtils.isEmpty(this.filterClassList) || entityDescriptor.hasMovableEntitySelectionFilter();
    }

    private EntitySelector applyFiltering(PlanningEntityDescriptor entityDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        if (this.hasFiltering(entityDescriptor)) {
            ArrayList<SelectionFilter> filterList = new ArrayList<SelectionFilter>(this.filterClassList == null ? 1 : this.filterClassList.size() + 1);
            if (this.filterClassList != null) {
                for (Class<? extends SelectionFilter> filterClass : this.filterClassList) {
                    filterList.add(ConfigUtils.newInstance(this, "filterClass", filterClass));
                }
            }
            if (entityDescriptor.hasMovableEntitySelectionFilter()) {
                filterList.add(entityDescriptor.getMovableEntitySelectionFilter());
            }
            entitySelector = new FilteringEntitySelector(entitySelector, filterList);
        }
        return entitySelector;
    }

    private void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") and sorterComparatorClass (" + this.sorterComparatorClass + ") and sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and sorterOrder (" + (Object)((Object)this.sorterOrder) + ") and sorterClass (" + this.sorterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.SORTED) + ".");
        }
        if (this.sorterManner != null && this.sorterComparatorClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterComparatorClass (" + this.sorterComparatorClass + ").");
        }
        if (this.sorterManner != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterManner != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterManner != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterWeightFactoryClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has both a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterClass != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with sorterClass (" + this.sorterClass + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
    }

    private EntitySelector applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            if (this.sorterManner != null) {
                sorter = this.sorterManner.determineSorter(entitySelector.getEntityDescriptor());
            } else if (this.sorterComparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this, "sorterComparatorClass", this.sorterComparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterWeightFactoryClass != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this, "sorterWeightFactoryClass", this.sorterWeightFactoryClass);
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterClass != null) {
                sorter = ConfigUtils.newInstance(this, "sorterClass", this.sorterClass);
            } else {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a sorterManner (" + (Object)((Object)this.sorterManner) + ") or a sorterComparatorClass (" + this.sorterComparatorClass + ") or a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") or a sorterClass (" + this.sorterClass + ").");
            }
            entitySelector = new SortingEntitySelector(entitySelector, resolvedCacheType, sorter);
        }
        return entitySelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (this.probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    private EntitySelector applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (this.probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this, "probabilityWeightFactoryClass", this.probabilityWeightFactoryClass);
            entitySelector = new ProbabilityEntitySelector(entitySelector, resolvedCacheType, probabilityWeightFactory);
        }
        return entitySelector;
    }

    private EntitySelector applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            entitySelector = new ShufflingEntitySelector(entitySelector, resolvedCacheType);
        }
        return entitySelector;
    }

    private EntitySelector applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(entitySelector.getCacheType()) > 0) {
            entitySelector = new CachingEntitySelector(entitySelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return entitySelector;
    }

    private EntitySelector applyMimicRecording(HeuristicConfigPolicy configPolicy, EntitySelector entitySelector) {
        if (this.id != null) {
            if (this.id.isEmpty()) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has an empty id (" + this.id + ").");
            }
            MimicRecordingEntitySelector mimicRecordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
            configPolicy.addMimicRecordingEntitySelector(this.id, mimicRecordingEntitySelector);
            entitySelector = mimicRecordingEntitySelector;
        }
        return entitySelector;
    }

    public void inherit(EntitySelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.getId());
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.getMimicSelectorRef());
        this.entityClass = ConfigUtils.inheritOverwritableProperty(this.entityClass, inheritedConfig.getEntityClass());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.filterClassList = ConfigUtils.inheritOverwritableProperty(this.filterClassList, inheritedConfig.getFilterClassList());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass + ")";
    }

    public static enum EntitySorterManner {
        DECREASING_DIFFICULTY;


        public SelectionSorter determineSorter(PlanningEntityDescriptor entityDescriptor) {
            switch (this) {
                case DECREASING_DIFFICULTY: {
                    SelectionSorter sorter = entityDescriptor.getDecreasingDifficultySorter();
                    if (sorter == null) {
                        throw new IllegalArgumentException("The sorterManner (" + (Object)((Object)this) + ") on entity class (" + entityDescriptor.getPlanningEntityClass() + ") fails because that entity class's " + PlanningEntity.class.getSimpleName() + " annotation does not declare any difficulty comparison.");
                    }
                    return sorter;
                }
            }
            throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
        }
    }
}

