/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.termination;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.termination.AbstractTermination;
import org.optaplanner.core.impl.termination.AndCompositeTermination;
import org.optaplanner.core.impl.termination.OrCompositeTermination;
import org.optaplanner.core.impl.termination.ScoreAttainedTermination;
import org.optaplanner.core.impl.termination.StepCountTermination;
import org.optaplanner.core.impl.termination.Termination;
import org.optaplanner.core.impl.termination.TimeMillisSpendTermination;
import org.optaplanner.core.impl.termination.UnimprovedStepCountTermination;

@XStreamAlias(value="termination")
public class TerminationConfig
implements Cloneable {
    private Class<? extends Termination> terminationClass = null;
    private TerminationCompositionStyle terminationCompositionStyle = null;
    private Long maximumTimeMillisSpend = null;
    private Long maximumSecondsSpend = null;
    private Long maximumMinutesSpend = null;
    private Long maximumHoursSpend = null;
    private String scoreAttained = null;
    private Integer maximumStepCount = null;
    private Integer maximumUnimprovedStepCount = null;
    @XStreamImplicit(itemFieldName="termination")
    private List<TerminationConfig> terminationConfigList = null;

    public Class<? extends Termination> getTerminationClass() {
        return this.terminationClass;
    }

    public void setTerminationClass(Class<? extends Termination> terminationClass) {
        this.terminationClass = terminationClass;
    }

    public TerminationCompositionStyle getTerminationCompositionStyle() {
        return this.terminationCompositionStyle;
    }

    public void setTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
    }

    public Long getMaximumTimeMillisSpend() {
        return this.maximumTimeMillisSpend;
    }

    public void setMaximumTimeMillisSpend(Long maximumTimeMillisSpend) {
        this.maximumTimeMillisSpend = maximumTimeMillisSpend;
    }

    public Long getMaximumSecondsSpend() {
        return this.maximumSecondsSpend;
    }

    public void setMaximumSecondsSpend(Long maximumSecondsSpend) {
        this.maximumSecondsSpend = maximumSecondsSpend;
    }

    public Long getMaximumMinutesSpend() {
        return this.maximumMinutesSpend;
    }

    public void setMaximumMinutesSpend(Long maximumMinutesSpend) {
        this.maximumMinutesSpend = maximumMinutesSpend;
    }

    public Long getMaximumHoursSpend() {
        return this.maximumHoursSpend;
    }

    public void setMaximumHoursSpend(Long maximumHoursSpend) {
        this.maximumHoursSpend = maximumHoursSpend;
    }

    public String getScoreAttained() {
        return this.scoreAttained;
    }

    public void setScoreAttained(String scoreAttained) {
        this.scoreAttained = scoreAttained;
    }

    public Integer getMaximumStepCount() {
        return this.maximumStepCount;
    }

    public void setMaximumStepCount(Integer maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
    }

    public Integer getMaximumUnimprovedStepCount() {
        return this.maximumUnimprovedStepCount;
    }

    public void setMaximumUnimprovedStepCount(Integer maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
    }

    public List<TerminationConfig> getTerminationConfigList() {
        return this.terminationConfigList;
    }

    public void setTerminationConfigList(List<TerminationConfig> terminationConfigList) {
        this.terminationConfigList = terminationConfigList;
    }

    public Termination buildTermination(HeuristicConfigPolicy configPolicy, Termination chainedTermination) {
        Termination termination = this.buildTermination(configPolicy);
        if (termination == null) {
            return chainedTermination;
        }
        return new OrCompositeTermination(chainedTermination, termination);
    }

    public Termination buildTermination(HeuristicConfigPolicy configPolicy) {
        AbstractTermination termination;
        Long maximumTimeMillisSpendTotal;
        ArrayList<Termination> terminationList = new ArrayList<Termination>();
        if (this.terminationClass != null) {
            Termination termination2 = ConfigUtils.newInstance(this, "terminationClass", this.terminationClass);
            terminationList.add(termination2);
        }
        if ((maximumTimeMillisSpendTotal = this.calculateMaximumTimeMillisSpendTotal()) != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(maximumTimeMillisSpendTotal);
            terminationList.add(termination);
        }
        if (this.scoreAttained != null) {
            termination = new ScoreAttainedTermination();
            ((ScoreAttainedTermination)termination).setScoreAttained(configPolicy.getScoreDefinition().parseScore(this.scoreAttained));
            terminationList.add(termination);
        }
        if (this.maximumStepCount != null) {
            termination = new StepCountTermination();
            ((StepCountTermination)termination).setMaximumStepCount(this.maximumStepCount);
            terminationList.add(termination);
        }
        if (this.maximumUnimprovedStepCount != null) {
            termination = new UnimprovedStepCountTermination();
            ((UnimprovedStepCountTermination)termination).setMaximumUnimprovedStepCount(this.maximumUnimprovedStepCount);
            terminationList.add(termination);
        }
        if (!CollectionUtils.isEmpty(this.terminationConfigList)) {
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                Termination termination3 = terminationConfig.buildTermination(configPolicy);
                if (termination3 == null) continue;
                terminationList.add(termination3);
            }
        }
        if (terminationList.size() == 1) {
            return (Termination)terminationList.get(0);
        }
        if (terminationList.size() > 1) {
            AbstractCompositeTermination compositeTermination;
            if (this.terminationCompositionStyle == null || this.terminationCompositionStyle == TerminationCompositionStyle.OR) {
                compositeTermination = new OrCompositeTermination();
            } else if (this.terminationCompositionStyle == TerminationCompositionStyle.AND) {
                compositeTermination = new AndCompositeTermination();
            } else {
                throw new IllegalStateException("The terminationCompositionStyle (" + (Object)((Object)this.terminationCompositionStyle) + ") is not implemented.");
            }
            compositeTermination.setTerminationList(terminationList);
            return compositeTermination;
        }
        return null;
    }

    public Long calculateMaximumTimeMillisSpendTotal() {
        if (this.maximumTimeMillisSpend == null && this.maximumSecondsSpend == null && this.maximumMinutesSpend == null && this.maximumHoursSpend == null) {
            return null;
        }
        long maximumTimeMillisSpendTotal = 0L;
        if (this.maximumTimeMillisSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumTimeMillisSpend.longValue();
        }
        if (this.maximumSecondsSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumSecondsSpend * 1000L;
        }
        if (this.maximumMinutesSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumMinutesSpend * 60000L;
        }
        if (this.maximumHoursSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumHoursSpend * 3600000L;
        }
        return maximumTimeMillisSpendTotal;
    }

    public void shortenMaximumTimeMillisSpendTotal(long maximumTimeMillisSpendTotal) {
        Long oldMaximumTimeMillisSpendTotal = this.calculateMaximumTimeMillisSpendTotal();
        if (oldMaximumTimeMillisSpendTotal == null || maximumTimeMillisSpendTotal < oldMaximumTimeMillisSpendTotal) {
            this.maximumTimeMillisSpend = maximumTimeMillisSpendTotal;
            this.maximumSecondsSpend = null;
            this.maximumMinutesSpend = null;
            this.maximumHoursSpend = null;
        }
    }

    public void inherit(TerminationConfig inheritedConfig) {
        if (this.terminationClass == null) {
            this.terminationClass = inheritedConfig.getTerminationClass();
        }
        if (this.terminationCompositionStyle == null) {
            this.terminationCompositionStyle = inheritedConfig.getTerminationCompositionStyle();
        }
        if (this.maximumTimeMillisSpend == null) {
            this.maximumTimeMillisSpend = inheritedConfig.getMaximumTimeMillisSpend();
        }
        if (this.maximumSecondsSpend == null) {
            this.maximumSecondsSpend = inheritedConfig.getMaximumSecondsSpend();
        }
        if (this.maximumMinutesSpend == null) {
            this.maximumMinutesSpend = inheritedConfig.getMaximumMinutesSpend();
        }
        if (this.maximumHoursSpend == null) {
            this.maximumHoursSpend = inheritedConfig.getMaximumHoursSpend();
        }
        if (this.scoreAttained == null) {
            this.scoreAttained = inheritedConfig.getScoreAttained();
        }
        if (this.maximumStepCount == null) {
            this.maximumStepCount = inheritedConfig.getMaximumStepCount();
        }
        if (this.maximumUnimprovedStepCount == null) {
            this.maximumUnimprovedStepCount = inheritedConfig.getMaximumUnimprovedStepCount();
        }
        this.terminationConfigList = ConfigUtils.inheritMergeableListProperty(this.terminationConfigList, inheritedConfig.getTerminationConfigList());
    }

    public TerminationConfig clone() {
        TerminationConfig clone;
        try {
            clone = (TerminationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible exception because TerminationConfig implements Cloneable.", e);
        }
        if (this.terminationConfigList != null) {
            ArrayList<TerminationConfig> clonedTerminationConfigList = new ArrayList<TerminationConfig>(this.terminationConfigList.size());
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                TerminationConfig clonedTerminationConfig = terminationConfig.clone();
                clonedTerminationConfigList.add(clonedTerminationConfig);
            }
            clone.terminationConfigList = clonedTerminationConfigList;
        } else {
            clone.terminationConfigList = null;
        }
        return clone;
    }

    public static enum TerminationCompositionStyle {
        AND,
        OR;

    }
}

