/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractTermination;

public class ScoreAttainedTermination
extends AbstractTermination {
    private Score scoreAttained;

    public void setScoreAttained(Score scoreAttained) {
        this.scoreAttained = scoreAttained;
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.isTerminated(solverScope.isBestSolutionInitialized(), solverScope.getBestScore());
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        return this.isTerminated(phaseScope.isBestSolutionInitialized(), phaseScope.getBestScore());
    }

    private boolean isTerminated(boolean bestSolutionInitialized, Score bestScore) {
        return bestSolutionInitialized && bestScore.compareTo(this.scoreAttained) >= 0;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        Score startingInitializedScore = solverScope.getStartingInitializedScore();
        Score bestScore = solverScope.getBestScore();
        return solverScope.getScoreDefinition().calculateTimeGradient(startingInitializedScore, this.scoreAttained, bestScore);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        Score startingInitializedScore = phaseScope.getStartingScore();
        Score bestScore = phaseScope.getBestScore();
        return phaseScope.getScoreDefinition().calculateTimeGradient(startingInitializedScore, this.scoreAttained, bestScore);
    }
}

