/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CartesianProductMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.DummyMove;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataMultiVarEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CartesianProductMoveSelectorTest {
    @Test
    public void originSelectionNotIgnoringEmpty() {
        this.originSelection(false);
    }

    @Test
    public void originSelectionIgnoringEmpty() {
        this.originSelection(true);
    }

    public void originSelection(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1+b1", "a1+b2", "a2+b1", "a2+b2", "a3+b1", "a3+b2");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void emptyOriginSelectionNotIgnoringEmpty() {
        this.emptyOriginSelection(false);
    }

    @Test
    public void emptyOriginSelectionIgnoringEmpty() {
        this.emptyOriginSelection(true);
    }

    public void emptyOriginSelection(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        if (ignoreEmptyChildIterators) {
            PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1", "a2", "a3");
        } else {
            PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        }
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void originSelection3ChildMoveSelectorsNotIgnoringEmpty() {
        this.originSelection3ChildMoveSelectors(false);
    }

    @Test
    public void originSelection3ChildMoveSelectorsIgnoringEmpty() {
        this.originSelection3ChildMoveSelectors(true);
    }

    public void originSelection3ChildMoveSelectors(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("c1"), new DummyMove("c2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1+b1+c1", "a1+b1+c2", "a1+b2+c1", "a1+b2+c2", "a2+b1+c1", "a2+b1+c2", "a2+b2+c1", "a2+b2+c2");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void emptyOriginSelection3ChildMoveSelectorsNotIgnoringEmpty() {
        this.emptyOriginSelection3ChildMoveSelectors(false);
    }

    @Test
    public void emptyOriginSelection3ChildMoveSelectorsIgnoringEmpty() {
        this.emptyOriginSelection3ChildMoveSelectors(true);
    }

    public void emptyOriginSelection3ChildMoveSelectors(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("c1"), new DummyMove("c2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        if (ignoreEmptyChildIterators) {
            PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a1+c1", "a1+c2", "a2+c1", "a2+c2");
        } else {
            PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        }
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void classicRandomSelectionNotIgnoringEmpty() {
        this.classicRandomSelection(false);
    }

    @Test
    public void classicRandomSelectionIgnoringEmpty() {
        this.classicRandomSelection(true);
    }

    public void classicRandomSelection(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, true);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, 6L, "a1+b1", "a2+b2", "a3+b1", "a1+b2", "a2+b1", "a3+b2");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void emptyRandomSelectionNotIgnoringEmpty() {
        this.emptyRandomSelection(false);
    }

    @Test
    public void emptyRandomSelectionIgnoringEmpty() {
        this.emptyRandomSelection(true);
    }

    public void emptyRandomSelection(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, true);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        if (ignoreEmptyChildIterators) {
            PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, "b1", "b2");
        } else {
            PlannerAssert.assertEmptyNeverEndingMoveSelector((MoveSelector)moveSelector);
        }
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void randomSelection3ChildMoveSelectorsNotIgnoringEmpty() {
        this.randomSelection3ChildMoveSelectors(false);
    }

    @Test
    public void randomSelection3ChildMoveSelectorsIgnoringEmpty() {
        this.randomSelection3ChildMoveSelectors(true);
    }

    public void randomSelection3ChildMoveSelectors(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("c1"), new DummyMove("c2")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, true);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, 8L, "a1+b1+c1", "a2+b2+c2", "a1+b1+c1");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void emptyRandomSelection3ChildMoveSelectorsNotIgnoringEmpty() {
        this.emptyRandomSelection3ChildMoveSelectors(false);
    }

    @Test
    public void emptyRandomSelection3ChildMoveSelectorsIgnoringEmpty() {
        this.emptyRandomSelection3ChildMoveSelectors(true);
    }

    public void emptyRandomSelection3ChildMoveSelectors(boolean ignoreEmptyChildIterators) {
        ArrayList<MoveSelector> childMoveSelectorList = new ArrayList<MoveSelector>();
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("b1"), new DummyMove("b2")));
        childMoveSelectorList.add(SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("c1"), new DummyMove("c2"), new DummyMove("c3")));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(childMoveSelectorList, ignoreEmptyChildIterators, true);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        if (ignoreEmptyChildIterators) {
            PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, 6L, "b1+c1", "b2+c2", "b1+c3");
        } else {
            PlannerAssert.assertEmptyNeverEndingMoveSelector((MoveSelector)moveSelector);
        }
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(0), 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelectorList.get(1), 1, 1, 1);
    }

    @Test
    public void originalMimicNotIgnoringEmpty() {
        this.originalMimic(false);
    }

    @Test
    public void originalMimicIgnoringEmpty() {
        this.originalMimic(true);
    }

    public void originalMimic(boolean ignoreEmptyChildIterators) {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataMultiVarEntity.class, new TestdataMultiVarEntity("a"), new TestdataMultiVarEntity("b"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
        ValueSelector primaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "primaryValue", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ValueSelector secondaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "secondaryValue", new TestdataValue("8"), new TestdataValue("9"));
        ArrayList<ChangeMoveSelector> moveSelectorList = new ArrayList<ChangeMoveSelector>(2);
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)recordingEntitySelector, primaryValueSelector, false));
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector(recordingEntitySelector), secondaryValueSelector, false));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(moveSelectorList, ignoreEmptyChildIterators, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, Long.MIN_VALUE, "a->1+a->8", "a->1+a->9", "a->2+a->8", "a->2+a->9", "a->3+a->8", "a->3+a->9", "b->1+b->8", "b->1+b->9", "b->2+b->8", "b->2+b->9", "b->3+b->8", "b->3+b->9");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, Long.MIN_VALUE, "a->1+a->8", "a->1+a->9", "a->2+a->8", "a->2+a->9", "a->3+a->8", "a->3+a->9", "b->1+b->8", "b->1+b->9", "b->2+b->8", "b->2+b->9", "b->3+b->8", "b->3+b->9");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 1, 2);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)primaryValueSelector, 1, 1, 2);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)secondaryValueSelector, 1, 1, 2);
    }

    @Test
    public void randomMimicNotIgnoringEmpty() {
        this.randomMimic(false);
    }

    @Test
    public void randomMimicIgnoringEmpty() {
        this.randomMimic(true);
    }

    public void randomMimic(boolean ignoreEmptyChildIterators) {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataMultiVarEntity.class, new TestdataMultiVarEntity("a"), new TestdataMultiVarEntity("b"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
        ValueSelector primaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "primaryValue", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ValueSelector secondaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "secondaryValue", new TestdataValue("8"), new TestdataValue("9"));
        ArrayList<ChangeMoveSelector> moveSelectorList = new ArrayList<ChangeMoveSelector>(2);
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)recordingEntitySelector, primaryValueSelector, false));
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector(recordingEntitySelector), secondaryValueSelector, false));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(moveSelectorList, ignoreEmptyChildIterators, true);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, 24L, "a->1+a->8", "a->2+a->9", "a->3+a->8", "b->1+a->9", "b->2+b->8", "b->3+b->9");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)primaryValueSelector, 1, 1, 1);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)secondaryValueSelector, 1, 1, 1);
    }
}

