/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMoveSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class SwapMoveSelectorTest {
    @Test
    public void originalLeftEqualsRight() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.buildEntityDescriptor(), new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        SwapMoveSelector moveSelector = new SwapMoveSelector(entitySelector, entitySelector, entitySelector.getEntityDescriptor().getVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->b", "a<->c", "a<->d", "b<->c", "b<->d", "c<->d");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->b", "a<->c", "a<->d", "b<->c", "b<->d", "c<->d");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->b", "a<->c", "a<->d", "b<->c", "b<->d", "c<->d");
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->b", "a<->c", "a<->d", "b<->c", "b<->d", "c<->d");
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->b", "a<->c", "a<->d", "b<->c", "b<->d", "c<->d");
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
    }

    @Test
    public void emptyOriginalLeftEqualsRight() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.buildEntityDescriptor(), new Object[0]);
        SwapMoveSelector moveSelector = new SwapMoveSelector(entitySelector, entitySelector, entitySelector.getEntityDescriptor().getVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
    }

    @Test
    public void originalLeftUnequalsRight() {
        PlanningEntityDescriptor entityDescriptor = TestdataEntity.buildEntityDescriptor();
        EntitySelector leftEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        EntitySelector rightEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("x"), new TestdataEntity("y"), new TestdataEntity("z"));
        SwapMoveSelector moveSelector = new SwapMoveSelector(leftEntitySelector, rightEntitySelector, leftEntitySelector.getEntityDescriptor().getVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->x", "a<->y", "a<->z", "b<->x", "b<->y", "b<->z", "c<->x", "c<->y", "c<->z", "d<->x", "d<->y", "d<->z");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->x", "a<->y", "a<->z", "b<->x", "b<->y", "b<->z", "c<->x", "c<->y", "c<->z", "d<->x", "d<->y", "d<->z");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->x", "a<->y", "a<->z", "b<->x", "b<->y", "b<->z", "c<->x", "c<->y", "c<->z", "d<->x", "d<->y", "d<->z");
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->x", "a<->y", "a<->z", "b<->x", "b<->y", "b<->z", "c<->x", "c<->y", "c<->z", "d<->x", "d<->y", "d<->z");
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a<->x", "a<->y", "a<->z", "b<->x", "b<->y", "b<->z", "c<->x", "c<->y", "c<->z", "d<->x", "d<->y", "d<->z");
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)leftEntitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)rightEntitySelector, 1, 2, 5);
    }

    @Test
    public void emptyRightOriginalLeftUnequalsRight() {
        PlanningEntityDescriptor entityDescriptor = TestdataEntity.buildEntityDescriptor();
        EntitySelector leftEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        EntitySelector rightEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new Object[0]);
        SwapMoveSelector moveSelector = new SwapMoveSelector(leftEntitySelector, rightEntitySelector, leftEntitySelector.getEntityDescriptor().getVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)leftEntitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)rightEntitySelector, 1, 2, 5);
    }
}

