/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.DefaultSubChainSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class DefaultSubChainSelectorTest {
    @Test
    public void original() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, b1, b2});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4, b0, b1, b2);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, "[a1]", "[a1, a2]", "[a1, a2, a3]", "[a1, a2, a3, a4]", "[a2]", "[a2, a3]", "[a2, a3, a4]", "[a3]", "[a3, a4]", "[a4]", "[b1]", "[b1, b2]", "[b2]");
        subChainSelector.stepEnded(stepScopeA1);
        a4.setChainedObject(a2);
        a3.setChainedObject(b1);
        b2.setChainedObject(a3);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA2);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, "[a1]", "[a1, a2]", "[a1, a2, a4]", "[a2]", "[a2, a4]", "[a4]", "[b1]", "[b1, a3]", "[b1, a3, b2]", "[a3]", "[a3, b2]", "[b2]");
        subChainSelector.stepEnded(stepScopeA2);
        subChainSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        subChainSelector.stepStarted(stepScopeB1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, "[a1]", "[a1, a2]", "[a1, a2, a4]", "[a2]", "[a2, a4]", "[a4]", "[b1]", "[b1, a3]", "[b1, a3, b2]", "[a3]", "[a3, b2]", "[b2]");
        subChainSelector.stepEnded(stepScopeB1);
        subChainSelector.phaseEnded(phaseScopeB);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 3);
    }

    @Test
    public void emptyEntitySelectorOriginal() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[0]);
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, b0);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, new String[0]);
        subChainSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA2);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, new String[0]);
        subChainSelector.stepEnded(stepScopeA2);
        subChainSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        subChainSelector.stepStarted(stepScopeB1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, new String[0]);
        subChainSelector.stepEnded(stepScopeB1);
        subChainSelector.phaseEnded(phaseScopeB);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 3);
    }

    private void assertAllCodesOfSubChainSelector(SubChainSelector subChainSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(subChainSelector.iterator(), codes);
        Assert.assertEquals((Object)false, (Object)subChainSelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)subChainSelector.isNeverEnding());
        Assert.assertEquals((long)codes.length, (long)subChainSelector.getSize());
    }

    @Test
    public void originalMinimum2Maximum3() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, b1, b2});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4, b0, b1, b2);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 2, 3);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, "[a1, a2]", "[a1, a2, a3]", "[a2, a3]", "[a2, a3, a4]", "[a3, a4]", "[b1, b2]");
        subChainSelector.stepEnded(stepScopeA1);
        subChainSelector.phaseEnded(phaseScopeA);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 1, 1);
    }

    @Test
    public void originalMinimum3Maximum3() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, b1, b2});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4, b0, b1, b2);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, false, 3, 3);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfSubChainSelector((SubChainSelector)subChainSelector, "[a1, a2, a3]", "[a2, a3, a4]");
        subChainSelector.stepEnded(stepScopeA1);
        subChainSelector.phaseEnded(phaseScopeA);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 1, 1);
    }

    @Test
    public void random() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, true, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)new Random(0L));
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertContainsCodesOfNeverEndingSubChainSelector(subChainSelector, new SubChain(Arrays.asList(a1)), new SubChain(Arrays.asList(a2)), new SubChain(Arrays.asList(a3)), new SubChain(Arrays.asList(a4)), new SubChain(Arrays.asList(a1, a2)), new SubChain(Arrays.asList(a2, a3)), new SubChain(Arrays.asList(a3, a4)), new SubChain(Arrays.asList(a1, a2, a3)), new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(a1, a2, a3, a4)));
        subChainSelector.stepEnded(stepScopeA1);
        subChainSelector.phaseEnded(phaseScopeA);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 1, 1);
    }

    @Test
    public void randomMinimum2Maximum3() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, true, 2, 3);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)new Random(0L));
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertContainsCodesOfNeverEndingSubChainSelector(subChainSelector, new SubChain(Arrays.asList(a1, a2)), new SubChain(Arrays.asList(a2, a3)), new SubChain(Arrays.asList(a3, a4)), new SubChain(Arrays.asList(a1, a2, a3)), new SubChain(Arrays.asList(a2, a3, a4)));
        subChainSelector.stepEnded(stepScopeA1);
        subChainSelector.phaseEnded(phaseScopeA);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 1, 1);
    }

    @Test
    public void randomMinimum3Maximum3() {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(TestdataChainedEntity.class, "chainedObject");
        Mockito.when((Object)variableDescriptor.isChained()).thenReturn((Object)true);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4});
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, a0, a1, a2, a3, a4);
        DefaultSubChainSelector subChainSelector = new DefaultSubChainSelector(valueSelector, true, 3, 3);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)new Random(0L));
        subChainSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        subChainSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        subChainSelector.stepStarted(stepScopeA1);
        this.assertContainsCodesOfNeverEndingSubChainSelector(subChainSelector, new SubChain(Arrays.asList(a1, a2, a3)), new SubChain(Arrays.asList(a2, a3, a4)));
        subChainSelector.stepEnded(stepScopeA1);
        subChainSelector.phaseEnded(phaseScopeA);
        subChainSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 1, 1);
    }

    private void assertContainsCodesOfNeverEndingSubChainSelector(DefaultSubChainSelector subChainSelector, SubChain ... subChains) {
        Iterator iterator = subChainSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        int selectionSize = subChains.length;
        HashMap<SubChain, Integer> subChainCountMap = new HashMap<SubChain, Integer>(selectionSize);
        for (int i = 0; i < selectionSize * 10; ++i) {
            this.collectNextSubChain(iterator, subChainCountMap);
        }
        for (SubChain subChain : subChains) {
            Integer count = (Integer)subChainCountMap.remove(subChain);
            PlannerAssert.assertNotNull((String)("The subChain (" + subChain + ") was not collected."), (Object)count);
        }
        PlannerAssert.assertTrue((boolean)subChainCountMap.isEmpty());
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)subChainSelector.isContinuous());
        Assert.assertEquals((Object)true, (Object)subChainSelector.isNeverEnding());
        Assert.assertEquals((long)selectionSize, (long)subChainSelector.getSize());
    }

    private void collectNextSubChain(Iterator<SubChain> iterator, Map<SubChain, Integer> subChainCountMap) {
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        SubChain subChain = iterator.next();
        Integer count = subChainCountMap.get(subChain);
        if (count == null) {
            subChainCountMap.put(subChain, 1);
        } else {
            subChainCountMap.put(subChain, count + 1);
        }
    }
}

