/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Comparator;
import org.optaplanner.core.api.domain.value.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.value.FromEntityPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.CachingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityDependentSortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ProbabilityValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SortingValueSelector;

@XStreamAlias(value="valueSelector")
public class ValueSelectorConfig
extends SelectorConfig {
    protected String variableName = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    protected ValueSorterManner sorterManner = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public ValueSorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(ValueSorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    public Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public ValueSelector buildValueSelector(HeuristicConfigPolicy configPolicy, PlanningEntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        PlanningVariableDescriptor variableDescriptor = this.deduceVariableDescriptor(entityDescriptor, this.variableName);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        ValueSelector valueSelector = this.buildBaseValueSelector(configPolicy, variableDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(variableDescriptor, resolvedCacheType, resolvedSelectionOrder));
        valueSelector = this.applyInitializedChainedValueFilter(configPolicy, variableDescriptor, resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyReinitializeVariableFiltering(configPolicy, valueSelector);
        return valueSelector;
    }

    protected boolean determineBaseRandomSelection(PlanningVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached(variableDescriptor) && !this.hasFiltering();
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached(PlanningVariableDescriptor variableDescriptor) {
        return !variableDescriptor.getValueRangeDescriptor().isEntityDependent();
    }

    private ValueSelector buildBaseValueSelector(HeuristicConfigPolicy configPolicy, PlanningVariableDescriptor variableDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (variableDescriptor.getValueRangeDescriptor().isEntityDependent()) {
            FromEntityPropertyPlanningValueRangeDescriptor valueRangeDescriptor = (FromEntityPropertyPlanningValueRangeDescriptor)variableDescriptor.getValueRangeDescriptor();
            return new FromEntityPropertyValueSelector(valueRangeDescriptor, minimumCacheType, randomSelection);
        }
        if (variableDescriptor.isPlanningValuesCacheable()) {
            if (minimumCacheType.compareTo(SelectionCacheType.PHASE) < 0) {
                minimumCacheType = SelectionCacheType.PHASE;
            }
        } else if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        return new FromSolutionPropertyValueSelector(variableDescriptor, minimumCacheType, randomSelection);
    }

    private boolean hasFiltering() {
        return false;
    }

    protected ValueSelector applyInitializedChainedValueFilter(HeuristicConfigPolicy configPolicy, PlanningVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (configPolicy.isInitializedChainedValueFilterEnabled() && variableDescriptor.isChained()) {
            valueSelector = new InitializedValueSelector(valueSelector);
        }
        return valueSelector;
    }

    private void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") and sorterComparatorClass (" + this.sorterComparatorClass + ") and sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and sorterOrder (" + (Object)((Object)this.sorterOrder) + ") and sorterClass (" + this.sorterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.SORTED) + ".");
        }
        if (this.sorterManner != null && this.sorterComparatorClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterComparatorClass (" + this.sorterComparatorClass + ").");
        }
        if (this.sorterManner != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterManner != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterManner != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterWeightFactoryClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterClass != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterClass (" + this.sorterClass + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
    }

    private ValueSelector applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            if (this.sorterManner != null) {
                sorter = this.sorterManner.determineSorter(valueSelector.getVariableDescriptor());
            } else if (this.sorterComparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this, "sorterComparatorClass", this.sorterComparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterWeightFactoryClass != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this, "sorterWeightFactoryClass", this.sorterWeightFactoryClass);
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterClass != null) {
                sorter = ConfigUtils.newInstance(this, "sorterClass", this.sorterClass);
            } else {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a sorterManner (" + (Object)((Object)this.sorterManner) + ") or a sorterComparatorClass (" + this.sorterComparatorClass + ") or a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") or a sorterClass (" + this.sorterClass + ").");
            }
            if (valueSelector.getVariableDescriptor().getValueRangeDescriptor().isEntityDependent() && resolvedCacheType == SelectionCacheType.STEP) {
                valueSelector = new EntityDependentSortingValueSelector(valueSelector, resolvedCacheType, sorter);
            } else {
                if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                    throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
                }
                valueSelector = new SortingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, sorter);
            }
        }
        return valueSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (this.probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    private ValueSelector applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (this.probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this, "probabilityWeightFactoryClass", this.probabilityWeightFactoryClass);
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ProbabilityValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return valueSelector;
    }

    private ValueSelector applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ShufflingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType);
        }
        return valueSelector;
    }

    private ValueSelector applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(valueSelector.getCacheType()) > 0) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new CachingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return valueSelector;
    }

    private ValueSelector applyReinitializeVariableFiltering(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (configPolicy.isReinitializeVariableFilterEnabled()) {
            valueSelector = new ReinitializeVariableValueSelector(valueSelector);
        }
        return valueSelector;
    }

    public void inherit(ValueSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.variableName == null) {
            this.variableName = inheritedConfig.getVariableName();
        }
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + ")";
    }

    public static enum ValueSorterManner {
        INCREASING_STRENGTH;


        public SelectionSorter determineSorter(PlanningVariableDescriptor variableDescriptor) {
            switch (this) {
                case INCREASING_STRENGTH: {
                    SelectionSorter sorter = variableDescriptor.getIncreasingStrengthSorter();
                    if (sorter == null) {
                        throw new IllegalArgumentException("The sorterManner (" + (Object)((Object)this) + ") on entity class (" + variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ")'s variable (" + variableDescriptor.getVariableName() + ") fails because that variable getter's " + PlanningVariable.class.getSimpleName() + " annotation does not declare any strength comparison.");
                    }
                    return sorter;
                }
            }
            throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
        }
    }
}

