/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase;

import org.optaplanner.core.impl.bestsolution.BestSolutionRecaller;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.SolverPhase;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleSupport;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolverPhase
implements SolverPhase {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int phaseIndex = -1;
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected SolverPhaseLifecycleSupport solverPhaseLifecycleSupport = new SolverPhaseLifecycleSupport();

    public Termination getTermination() {
        return this.termination;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public void setPhaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.termination.solvingStarted(solverScope);
        this.solverPhaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.termination.solvingEnded(solverScope);
        this.solverPhaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        phaseScope.reset();
        this.bestSolutionRecaller.phaseStarted(phaseScope);
        this.termination.phaseStarted(phaseScope);
        this.solverPhaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepStarted(stepScope);
        this.termination.stepStarted(stepScope);
        this.solverPhaseLifecycleSupport.fireStepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepEnded(stepScope);
        this.termination.stepEnded(stepScope);
        this.solverPhaseLifecycleSupport.fireStepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.bestSolutionRecaller.phaseEnded(phaseScope);
        this.termination.phaseEnded(phaseScope);
        this.solverPhaseLifecycleSupport.firePhaseEnded(phaseScope);
    }

    @Override
    public void addSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.addEventListener(lifecycleListener);
    }

    @Override
    public void removeSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.removeEventListener(lifecycleListener);
    }
}

