/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractTermination;

public class StepCountTermination
extends AbstractTermination {
    private int maximumStepCount = 100;

    public void setMaximumStepCount(int maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
        if (maximumStepCount < 0) {
            throw new IllegalArgumentException("Property maximumStepCount (" + maximumStepCount + ") must be greater or equal to 0.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        int nextStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex() + 1;
        return nextStepIndex >= this.maximumStepCount;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        int nextStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex() + 1;
        double timeGradient = (double)nextStepIndex / (double)this.maximumStepCount;
        return Math.min(timeGradient, 1.0);
    }
}

