/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private int maximumUnimprovedStepCount = 100;

    public void setMaximumUnimprovedStepCount(int maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
        if (maximumUnimprovedStepCount < 0) {
            throw new IllegalArgumentException("Property maximumUnimprovedStepCount (" + maximumUnimprovedStepCount + ") must be greater or equal to 0.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        return unimprovedStepCount >= this.maximumUnimprovedStepCount;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.maximumUnimprovedStepCount;
        return Math.min(timeGradient, 1.0);
    }

    private int calculateUnimprovedStepCount(AbstractSolverPhaseScope phaseScope) {
        int bestStepIndex = phaseScope.getBestSolutionStepIndex();
        int lastStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex();
        return lastStepIndex - bestStepIndex;
    }
}

