/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.mimic;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class MimicReplayingEntitySelectorTest {
    @Test
    public void originalSelection() {
        EntitySelector childEntitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(childEntitySelector);
        MimicReplayingEntitySelector replayingEntitySelector = new MimicReplayingEntitySelector(recordingEntitySelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        recordingEntitySelector.solvingStarted(solverScope);
        replayingEntitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        recordingEntitySelector.phaseStarted(phaseScopeA);
        replayingEntitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        recordingEntitySelector.stepStarted(stepScopeA1);
        replayingEntitySelector.stepStarted(stepScopeA1);
        this.runOriginalAsserts(recordingEntitySelector, replayingEntitySelector);
        recordingEntitySelector.stepEnded(stepScopeA1);
        replayingEntitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        recordingEntitySelector.stepStarted(stepScopeA2);
        replayingEntitySelector.stepStarted(stepScopeA2);
        this.runOriginalAsserts(recordingEntitySelector, replayingEntitySelector);
        recordingEntitySelector.stepEnded(stepScopeA2);
        replayingEntitySelector.stepEnded(stepScopeA2);
        recordingEntitySelector.phaseEnded(phaseScopeA);
        replayingEntitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        recordingEntitySelector.phaseStarted(phaseScopeB);
        replayingEntitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        recordingEntitySelector.stepStarted(stepScopeB1);
        replayingEntitySelector.stepStarted(stepScopeB1);
        this.runOriginalAsserts(recordingEntitySelector, replayingEntitySelector);
        recordingEntitySelector.stepEnded(stepScopeB1);
        replayingEntitySelector.stepEnded(stepScopeB1);
        recordingEntitySelector.phaseEnded(phaseScopeB);
        replayingEntitySelector.phaseEnded(phaseScopeB);
        recordingEntitySelector.solvingEnded(solverScope);
        replayingEntitySelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childEntitySelector, 1, 2, 3);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)3))).iterator();
    }

    private void runOriginalAsserts(MimicRecordingEntitySelector recordingEntitySelector, MimicReplayingEntitySelector replayingEntitySelector) {
        Iterator recordingIterator = recordingEntitySelector.iterator();
        Assert.assertNotNull((Object)recordingIterator);
        Iterator replayingIterator = replayingEntitySelector.iterator();
        Assert.assertNotNull((Object)replayingIterator);
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("e1", recordingIterator.next());
        PlannerAssert.assertCode("e1", replayingIterator.next());
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("e2", recordingIterator.next());
        PlannerAssert.assertCode("e2", replayingIterator.next());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("e3", recordingIterator.next());
        PlannerAssert.assertCode("e3", replayingIterator.next());
        Assert.assertEquals((Object)false, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)false, (Object)recordingEntitySelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)replayingEntitySelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)recordingEntitySelector.isNeverEnding());
        Assert.assertEquals((Object)false, (Object)replayingEntitySelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)recordingEntitySelector.getSize());
        Assert.assertEquals((long)3L, (long)replayingEntitySelector.getSize());
    }
}

