/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.DummyMove;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public class GreatDelugeAcceptorTest {
    @Test
    public void testIsAccepted() {
        GreatDelugeAcceptor acceptor = new GreatDelugeAcceptor(1.2, 0.01);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
        acceptor.stepStarted(stepScope);
        LocalSearchMoveScope a1 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-2000));
        LocalSearchMoveScope a2 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1300));
        LocalSearchMoveScope a3 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1200));
        LocalSearchMoveScope b1 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1200));
        LocalSearchMoveScope b2 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-100));
        LocalSearchMoveScope c1 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1100));
        LocalSearchMoveScope c2 = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-120));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(a1));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(a2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(a3));
        acceptor.stepEnded(stepScope);
        phaseScope.setLastCompletedStepScope(stepScope);
        acceptor.phaseEnded(phaseScope);
    }

    private LocalSearchSolverPhaseScope createPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setSolutionDescriptor(TestdataSolution.buildSolutionDescriptor());
        scoreDirectorFactory.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        solverScope.setScoreDirector((ScoreDirector)scoreDirectorFactory.buildScoreDirector());
        solverScope.setWorkingRandom(new Random(){

            @Override
            public double nextDouble() {
                return 0.2;
            }
        });
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore((Score)SimpleScore.valueOf((int)-1000));
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        return phaseScope;
    }

    public LocalSearchMoveScope createMoveScope(LocalSearchStepScope stepScope, Score score) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        return moveScope;
    }
}

