/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.hillclimbing;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.localsearch.decider.acceptor.hillclimbing.HillClimbingAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class HillClimbingAcceptorTest {
    @Test
    public void hillClimbingEnabled() {
        HillClimbingAcceptor acceptor = new HillClimbingAcceptor();
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore((Score)SimpleScore.valueOf((int)-1000));
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope0, -500);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -800)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -2000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope0.setStep(moveScope1.getMove());
        stepScope0.setScore(moveScope1.getScore());
        solverScope.setBestScore(moveScope1.getScore());
        acceptor.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope1, 600);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -900)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -700)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -1000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -500)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -501)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope1.setStep(moveScope2.getMove());
        stepScope1.setScore(moveScope2.getScore());
        acceptor.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        acceptor.phaseEnded(phaseScope);
    }

    private LocalSearchMoveScope buildMoveScope(LocalSearchStepScope stepScope, int score) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        Move move = (Move)Mockito.mock(Move.class);
        moveScope.setMove(move);
        moveScope.setScore((Score)SimpleScore.valueOf((int)score));
        return moveScope;
    }
}

