/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.impl.score.buildin.AbstractScoreTest;
import org.optaplanner.core.impl.util.SerializationTestUtils;

public class HardSoftBigDecimalScoreTest
extends AbstractScoreTest {
    @Test
    public void feasible() {
        HardSoftBigDecimalScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-5"), (BigDecimal)new BigDecimal("-300")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-5"), (BigDecimal)new BigDecimal("4000")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-0.007"), (BigDecimal)new BigDecimal("4000"))});
        HardSoftBigDecimalScoreTest.assertScoreFeasible(new FeasibilityScore[]{HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("-300.007")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("-300")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("2"), (BigDecimal)new BigDecimal("-300"))});
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("19"), (BigDecimal)new BigDecimal("-320")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("20"), (BigDecimal)new BigDecimal("-20")).add(HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-1"), (BigDecimal)new BigDecimal("-300"))));
    }

    @Test
    public void subtract() {
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("21"), (BigDecimal)new BigDecimal("280")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("20"), (BigDecimal)new BigDecimal("-20")).subtract(HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-1"), (BigDecimal)new BigDecimal("-300"))));
    }

    @Test
    public void multiply() {
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("6.0"), (BigDecimal)new BigDecimal("-6.0")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("5.0"), (BigDecimal)new BigDecimal("-5.0")).multiply(1.2));
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("1.2"), (BigDecimal)new BigDecimal("-1.2")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("1.0"), (BigDecimal)new BigDecimal("-1.0")).multiply(1.2));
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("4.8"), (BigDecimal)new BigDecimal("-4.8")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("4.0"), (BigDecimal)new BigDecimal("-4.0")).multiply(1.2));
    }

    @Test
    public void divide() {
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("5.0"), (BigDecimal)new BigDecimal("-5.0")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("25.0"), (BigDecimal)new BigDecimal("-25.0")).divide(5.0));
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("4.2"), (BigDecimal)new BigDecimal("-4.2")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("21.0"), (BigDecimal)new BigDecimal("-21.0")).divide(5.0));
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("4.8"), (BigDecimal)new BigDecimal("-4.8")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("24.0"), (BigDecimal)new BigDecimal("-24.0")).divide(5.0));
    }

    @Test
    public void power() {
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("16.0"), (BigDecimal)new BigDecimal("25.0")), (Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-4.0"), (BigDecimal)new BigDecimal("5.0")).power(2.0));
    }

    @Test
    public void equalsAndHashCode() {
        HardSoftBigDecimalScoreTest.assertScoresEqualsAndHashCode(new Score[]{HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-10"), (BigDecimal)new BigDecimal("-20")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-10"), (BigDecimal)new BigDecimal("-20"))});
    }

    @Test
    public void compareTo() {
        HardSoftBigDecimalScoreTest.assertScoreCompareToOrder(new Score[]{HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-20.06"), (BigDecimal)new BigDecimal("-20")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-20.007"), (BigDecimal)new BigDecimal("-20")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-20"), (BigDecimal)new BigDecimal("-20.06")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-20"), (BigDecimal)new BigDecimal("-20.007")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-20"), (BigDecimal)new BigDecimal("-20")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-1"), (BigDecimal)new BigDecimal("-300")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-1"), (BigDecimal)new BigDecimal("4000")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("-1")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0")), HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"))});
    }

    @Test
    public void serializeAndDeserialize() {
        HardSoftBigDecimalScore input = HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-12.3"), (BigDecimal)new BigDecimal("3400.5"));
        SerializationTestUtils.serializeAndDeserializeWithAll(input, new SerializationTestUtils.OutputAsserter<HardSoftBigDecimalScore>(){

            @Override
            public void assertOutput(HardSoftBigDecimalScore output) {
                Assert.assertEquals((Object)new BigDecimal("-12.3"), (Object)output.getHardScore());
                Assert.assertEquals((Object)new BigDecimal("3400.5"), (Object)output.getSoftScore());
            }
        });
    }
}

