/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.value;

import java.lang.reflect.Method;
import java.util.Collection;
import org.optaplanner.core.api.domain.value.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.DefaultReadMethodAccessor;
import org.optaplanner.core.impl.domain.common.ReadMethodAccessor;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.value.AbstractPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class FromSolutionPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private ReadMethodAccessor rangeReadMethodAccessor;

    public FromSolutionPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, Method readMethod) {
        super(variableDescriptor);
        this.rangeReadMethodAccessor = new DefaultReadMethodAccessor(readMethod);
        ValueRangeProvider valueRangeProviderAnnotation = readMethod.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The readMethod (" + readMethod + ") must have a valueRangeProviderAnnotation (" + valueRangeProviderAnnotation + ").");
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        PlanningEntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        if (!Collection.class.isAssignableFrom(this.rangeReadMethodAccessor.getReturnType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated method (" + this.rangeReadMethodAccessor.getReadMethod() + ") that does not return a " + Collection.class.getSimpleName() + ".");
        }
    }

    @Override
    public boolean isEntityDependent() {
        return false;
    }

    @Override
    public Collection<?> extractAllValues(Solution solution) {
        return (Collection)this.rangeReadMethodAccessor.read(solution);
    }

    @Override
    public Collection<?> extractValues(Solution solution, Object entity) {
        return this.extractAllValues(solution);
    }

    @Override
    public long getValueCount(Solution solution, Object entity) {
        return this.extractAllValues(solution).size();
    }

    @Override
    public boolean isValuesCacheable() {
        return true;
    }
}

