/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PlanningVariableListenerSupport {
    private final Map<PlanningVariableDescriptor, List<PlanningVariableListener>> variableListenerMap;
    private final Map<PlanningEntityDescriptor, List<PlanningVariableListener>> entityVariableListenerMap;

    public PlanningVariableListenerSupport(Map<PlanningVariableDescriptor, List<PlanningVariableListener>> variableListenerMap) {
        this.variableListenerMap = variableListenerMap;
        this.entityVariableListenerMap = new LinkedHashMap<PlanningEntityDescriptor, List<PlanningVariableListener>>(variableListenerMap.size());
        for (Map.Entry<PlanningVariableDescriptor, List<PlanningVariableListener>> entry : variableListenerMap.entrySet()) {
            PlanningEntityDescriptor entityDescriptor = entry.getKey().getEntityDescriptor();
            List<PlanningVariableListener> variableListenerList = entry.getValue();
            List<PlanningVariableListener> entityVariableListenerList = this.entityVariableListenerMap.get(entityDescriptor);
            if (entityVariableListenerList == null) {
                entityVariableListenerList = new ArrayList<PlanningVariableListener>(variableListenerList);
                this.entityVariableListenerMap.put(entityDescriptor, entityVariableListenerList);
                continue;
            }
            entityVariableListenerList.addAll(variableListenerList);
        }
    }

    public void beforeEntityAdded(ScoreDirector scoreDirector, PlanningEntityDescriptor entityDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityAdded(scoreDirector, entity);
        }
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, PlanningEntityDescriptor entityDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityAdded(scoreDirector, entity);
        }
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, PlanningVariableDescriptor variableDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
            variableListener.beforeVariableChanged(scoreDirector, entity);
        }
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, PlanningVariableDescriptor variableDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
            variableListener.afterVariableChanged(scoreDirector, entity);
        }
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, PlanningEntityDescriptor entityDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityRemoved(scoreDirector, entity);
        }
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, PlanningEntityDescriptor entityDescriptor, Object entity) {
        for (PlanningVariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityRemoved(scoreDirector, entity);
        }
    }
}

