/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;

public class WeightFactorySelectionSorter
implements SelectionSorter<Object> {
    private final SelectionSorterWeightFactory<Solution, Object> selectionSorterWeightFactory;
    private final Comparator<Object> appliedWeightComparator;

    public WeightFactorySelectionSorter(SelectionSorterWeightFactory<Solution, Object> selectionSorterWeightFactory, SelectionSorterOrder selectionSorterOrder) {
        this.selectionSorterWeightFactory = selectionSorterWeightFactory;
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedWeightComparator = new ComparableComparator();
                break;
            }
            case DESCENDING: {
                this.appliedWeightComparator = Collections.reverseOrder();
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + (Object)((Object)selectionSorterOrder) + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector scoreDirector, List<Object> selectionList) {
        Solution solution = scoreDirector.getWorkingSolution();
        TreeMap<Object, Object> selectionMap = new TreeMap<Object, Object>(this.appliedWeightComparator);
        for (Object selection : selectionList) {
            Comparable difficultyWeight = this.selectionSorterWeightFactory.createSorterWeight(solution, selection);
            Object previous = selectionMap.put(difficultyWeight, selection);
            if (previous == null) continue;
            throw new IllegalStateException("The selectionList contains 2 times the same selection (" + previous + ") and (" + selection + ").");
        }
        selectionList.clear();
        selectionList.addAll(selectionMap.values());
    }
}

