/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractTermination;
import org.optaplanner.core.impl.termination.Termination;

public abstract class AbstractCompositeTermination
extends AbstractTermination
implements Termination {
    protected List<Termination> terminationList;

    public AbstractCompositeTermination() {
    }

    public AbstractCompositeTermination(Termination ... terminations) {
        this.terminationList = Arrays.asList(terminations);
    }

    public void setTerminationList(List<Termination> terminationList) {
        this.terminationList = terminationList;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseStarted(phaseScope);
        }
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepStarted(stepScope);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingEnded(solverScope);
        }
    }
}

