/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.forager.ForagerConfig;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.localsearch.DefaultLocalSearchSolverPhase;
import org.optaplanner.core.impl.localsearch.LocalSearchSolverPhase;
import org.optaplanner.core.impl.localsearch.decider.LocalSearchDecider;
import org.optaplanner.core.impl.localsearch.decider.forager.Forager;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="localSearch")
public class LocalSearchSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamImplicit
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = null;
    @XStreamAlias(value="forager")
    private ForagerConfig foragerConfig = null;

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public ForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    @Override
    public LocalSearchSolverPhase buildSolverPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultLocalSearchSolverPhase phase = new DefaultLocalSearchSolverPhase();
        this.configureSolverPhase(phase, phaseIndex, phaseConfigPolicy, bestSolutionRecaller, solverTermination);
        phase.setDecider(this.buildDecider(phaseConfigPolicy, phase.getTermination()));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedStepScore(true);
        }
        return phase;
    }

    private LocalSearchDecider buildDecider(HeuristicConfigPolicy configPolicy, Termination termination) {
        LocalSearchDecider decider = new LocalSearchDecider();
        decider.setTermination(termination);
        MoveSelector moveSelector = this.buildMoveSelector(configPolicy);
        decider.setMoveSelector(moveSelector);
        AcceptorConfig acceptorConfig_ = this.acceptorConfig == null ? new AcceptorConfig() : this.acceptorConfig;
        decider.setAcceptor(acceptorConfig_.buildAcceptor(configPolicy));
        ForagerConfig foragerConfig_ = this.foragerConfig == null ? new ForagerConfig() : this.foragerConfig;
        Forager forager = foragerConfig_.buildForager(configPolicy);
        decider.setForager(forager);
        if (moveSelector.isNeverEnding() && !forager.supportsNeverEndingMoveSelector()) {
            throw new IllegalStateException("The moveSelector (" + moveSelector + ") has neverEnding (" + moveSelector.isNeverEnding() + "), but the forager (" + forager + ") does not support it." + " Configure the <forager> with <acceptedCountLimit>.");
        }
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    private MoveSelector buildMoveSelector(HeuristicConfigPolicy configPolicy) {
        MoveSelector moveSelector;
        SelectionCacheType defaultCacheType = SelectionCacheType.JUST_IN_TIME;
        SelectionOrder defaultSelectionOrder = SelectionOrder.RANDOM;
        if (ConfigUtils.isEmptyCollection(this.moveSelectorConfigList)) {
            UnionMoveSelectorConfig unionMoveSelectorConfig = new UnionMoveSelectorConfig();
            unionMoveSelectorConfig.setMoveSelectorConfigList(Arrays.asList(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig()));
            moveSelector = unionMoveSelectorConfig.buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder);
        } else if (this.moveSelectorConfigList.size() == 1) {
            moveSelector = this.moveSelectorConfigList.get(0).buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder);
        } else {
            throw new IllegalArgumentException("The moveSelectorConfigList (" + this.moveSelectorConfigList + ") must be a singleton or empty. Use a single " + UnionMoveSelectorConfig.class + " or " + CartesianProductMoveSelectorConfig.class + " element to nest multiple MoveSelectors.");
        }
        return moveSelector;
    }

    public void inherit(LocalSearchSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListProperty(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        if (this.acceptorConfig == null) {
            this.acceptorConfig = inheritedConfig.getAcceptorConfig();
        } else if (inheritedConfig.getAcceptorConfig() != null) {
            this.acceptorConfig.inherit(inheritedConfig.getAcceptorConfig());
        }
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }
}

