/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.score.director;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.config.util.KeyAsElementMapConverter;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftdouble.HardSoftDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplebigdecimal.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplelong.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreCalculator;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrendLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="scoreDirectorFactory")
public class ScoreDirectorFactoryConfig {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Class<? extends ScoreDefinition> scoreDefinitionClass = null;
    protected ScoreDefinitionType scoreDefinitionType = null;
    protected Integer bendableHardLevelCount = null;
    protected Integer bendableSoftLevelCount = null;
    protected Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass = null;
    protected Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = null;
    @XStreamOmitField
    protected KieBase kieBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> kieBaseConfigurationProperties = null;
    protected String initializingScoreTrend = null;
    @XStreamAlias(value="assertionScoreDirectorFactory")
    protected ScoreDirectorFactoryConfig assertionScoreDirectorFactory = null;

    public Class<? extends ScoreDefinition> getScoreDefinitionClass() {
        return this.scoreDefinitionClass;
    }

    public void setScoreDefinitionClass(Class<? extends ScoreDefinition> scoreDefinitionClass) {
        this.scoreDefinitionClass = scoreDefinitionClass;
    }

    public ScoreDefinitionType getScoreDefinitionType() {
        return this.scoreDefinitionType;
    }

    public void setScoreDefinitionType(ScoreDefinitionType scoreDefinitionType) {
        this.scoreDefinitionType = scoreDefinitionType;
    }

    public Integer getBendableHardLevelCount() {
        return this.bendableHardLevelCount;
    }

    public void setBendableHardLevelCount(Integer bendableHardLevelCount) {
        this.bendableHardLevelCount = bendableHardLevelCount;
    }

    public Integer getBendableSoftLevelCount() {
        return this.bendableSoftLevelCount;
    }

    public void setBendableSoftLevelCount(Integer bendableSoftLevelCount) {
        this.bendableSoftLevelCount = bendableSoftLevelCount;
    }

    public Class<? extends SimpleScoreCalculator> getSimpleScoreCalculatorClass() {
        return this.simpleScoreCalculatorClass;
    }

    public void setSimpleScoreCalculatorClass(Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass) {
        this.simpleScoreCalculatorClass = simpleScoreCalculatorClass;
    }

    public Class<? extends IncrementalScoreCalculator> getIncrementalScoreCalculatorClass() {
        return this.incrementalScoreCalculatorClass;
    }

    public void setIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
    }

    public KieBase getKieBase() {
        return this.kieBase;
    }

    public void setKieBase(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public Map<String, String> getKieBaseConfigurationProperties() {
        return this.kieBaseConfigurationProperties;
    }

    public void setKieBaseConfigurationProperties(Map<String, String> kieBaseConfigurationProperties) {
        this.kieBaseConfigurationProperties = kieBaseConfigurationProperties;
    }

    public String getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(String initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public ScoreDirectorFactoryConfig getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(ScoreDirectorFactoryConfig assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public ScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor) {
        ScoreDefinition scoreDefinition = this.buildScoreDefinition();
        return this.buildScoreDirectorFactory(environmentMode, solutionDescriptor, scoreDefinition);
    }

    protected ScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition) {
        AbstractScoreDirectorFactory scoreDirectorFactory = this.buildSimpleScoreDirectorFactory();
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildIncrementalScoreDirectorFactory();
        }
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildDroolsScoreDirectorFactory();
        }
        scoreDirectorFactory.setSolutionDescriptor(solutionDescriptor);
        scoreDirectorFactory.setScoreDefinition(scoreDefinition);
        if (this.assertionScoreDirectorFactory != null) {
            if (this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") cannot have a non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() + ").");
            }
            if (this.assertionScoreDirectorFactory.getScoreDefinitionClass() != null || this.assertionScoreDirectorFactory.getScoreDefinitionType() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") must reuse the scoreDefinition of its parent." + " It cannot have a non-null scoreDefinition* property.");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") requires an environmentMode (" + (Object)((Object)environmentMode) + ") of " + (Object)((Object)EnvironmentMode.FAST_ASSERT) + " or lower.");
            }
            scoreDirectorFactory.setAssertionScoreDirectorFactory(this.assertionScoreDirectorFactory.buildScoreDirectorFactory(EnvironmentMode.PRODUCTION, solutionDescriptor, scoreDefinition));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.initializingScoreTrend == null ? InitializingScoreTrendLevel.ANY.name() : this.initializingScoreTrend, scoreDefinition.getLevelCount()));
        return scoreDirectorFactory;
    }

    public ScoreDefinition buildScoreDefinition() {
        if (this.scoreDefinitionType != ScoreDefinitionType.BENDABLE && (this.bendableHardLevelCount != null || this.bendableSoftLevelCount != null)) {
            throw new IllegalArgumentException("With scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") there must be no bendableHardLevelCount (" + this.bendableHardLevelCount + ") or bendableSoftLevelCount (" + this.bendableSoftLevelCount + ").");
        }
        if (this.scoreDefinitionClass != null) {
            if (this.scoreDefinitionType != null || this.bendableHardLevelCount != null || this.bendableSoftLevelCount != null) {
                throw new IllegalStateException("With scoreDefinitionClass (" + this.scoreDefinitionClass + ") there must be no scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") or bendableHardLevelCount (" + this.bendableHardLevelCount + ") or bendableSoftLevelCount (" + this.bendableSoftLevelCount + ").");
            }
            return ConfigUtils.newInstance(this, "scoreDefinitionClass", this.scoreDefinitionClass);
        }
        if (this.scoreDefinitionType != null) {
            switch (this.scoreDefinitionType) {
                case SIMPLE: {
                    return new SimpleScoreDefinition();
                }
                case SIMPLE_LONG: {
                    return new SimpleLongScoreDefinition();
                }
                case SIMPLE_DOUBLE: {
                    return new SimpleDoubleScoreDefinition();
                }
                case SIMPLE_BIG_DECIMAL: {
                    return new SimpleBigDecimalScoreDefinition();
                }
                case HARD_SOFT: {
                    return new HardSoftScoreDefinition();
                }
                case HARD_SOFT_LONG: {
                    return new HardSoftLongScoreDefinition();
                }
                case HARD_SOFT_DOUBLE: {
                    return new HardSoftDoubleScoreDefinition();
                }
                case HARD_SOFT_BIG_DECIMAL: {
                    return new HardSoftBigDecimalScoreDefinition();
                }
                case HARD_MEDIUM_SOFT: {
                    return new HardMediumSoftScoreDefinition();
                }
                case HARD_MEDIUM_SOFT_LONG: {
                    return new HardMediumSoftLongScoreDefinition();
                }
                case BENDABLE: {
                    if (this.bendableHardLevelCount == null || this.bendableSoftLevelCount == null) {
                        throw new IllegalArgumentException("With scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") there must be a bendableHardLevelCount (" + this.bendableHardLevelCount + ") and a bendableSoftLevelCount (" + this.bendableSoftLevelCount + ").");
                    }
                    return new BendableScoreDefinition(this.bendableHardLevelCount, this.bendableSoftLevelCount);
                }
            }
            throw new IllegalStateException("The scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") is not implemented.");
        }
        return new SimpleScoreDefinition();
    }

    private AbstractScoreDirectorFactory buildSimpleScoreDirectorFactory() {
        if (this.simpleScoreCalculatorClass != null) {
            SimpleScoreCalculator simpleScoreCalculator = ConfigUtils.newInstance(this, "simpleScoreCalculatorClass", this.simpleScoreCalculatorClass);
            return new SimpleScoreDirectorFactory(simpleScoreCalculator);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildIncrementalScoreDirectorFactory() {
        if (this.incrementalScoreCalculatorClass != null) {
            return new IncrementalScoreDirectorFactory(this.incrementalScoreCalculatorClass);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildDroolsScoreDirectorFactory() {
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setKieBase(this.buildKieBase());
        return scoreDirectorFactory;
    }

    private KieBase buildKieBase() {
        if (this.kieBase != null) {
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlList)) {
                throw new IllegalArgumentException("If kieBase is not null, the scoreDrlList (" + this.scoreDrlList + ") must be empty.");
            }
            if (this.kieBaseConfigurationProperties != null) {
                throw new IllegalArgumentException("If kieBase is not null, the kieBaseConfigurationProperties (" + this.kieBaseConfigurationProperties + ") must be null.");
            }
            return this.kieBase;
        }
        if (ConfigUtils.isEmptyCollection(this.scoreDrlList)) {
            throw new IllegalArgumentException("The scoreDrlList (" + this.scoreDrlList + ") cannot be empty.");
        }
        KieServices kieServices = KieServices.Factory.get();
        KieResources kieResources = kieServices.getResources();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") does not exist as a classpath resource." + "Note that nor a file, nor a URL, nor a webapp resource are a valid classpath resource.");
            }
            String path = "src/main/resources/optaplanner-kie-namespace/" + scoreDrl;
            kieFileSystem.write(path, kieResources.newInputStreamResource(scoreDrlIn, "UTF-8"));
        }
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException("There are errors in the scoreDrl's:\n" + results.toString());
        }
        if (results.hasMessages(new Message.Level[]{Message.Level.WARNING})) {
            this.logger.warn("There are warning in the scoreDrl's:\n" + results.toString());
        }
        KieContainer kieContainer = kieServices.newKieContainer(kieBuilder.getKieModule().getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = kieServices.newKieBaseConfiguration();
        if (this.kieBaseConfigurationProperties != null) {
            for (Map.Entry<String, String> entry : this.kieBaseConfigurationProperties.entrySet()) {
                kieBaseConfiguration.setProperty(entry.getKey(), entry.getValue());
            }
        }
        kieBaseConfiguration.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        KieBase kieBase = kieContainer.newKieBase(kieBaseConfiguration);
        return kieBase;
    }

    public void inherit(ScoreDirectorFactoryConfig inheritedConfig) {
        if (this.scoreDefinitionClass == null && this.scoreDefinitionType == null && this.bendableHardLevelCount == null && this.bendableSoftLevelCount == null) {
            this.scoreDefinitionClass = inheritedConfig.getScoreDefinitionClass();
            this.scoreDefinitionType = inheritedConfig.getScoreDefinitionType();
            this.bendableHardLevelCount = inheritedConfig.getBendableHardLevelCount();
            this.bendableSoftLevelCount = inheritedConfig.getBendableSoftLevelCount();
        }
        this.simpleScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.simpleScoreCalculatorClass, inheritedConfig.getSimpleScoreCalculatorClass());
        this.incrementalScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.incrementalScoreCalculatorClass, inheritedConfig.getIncrementalScoreCalculatorClass());
        this.kieBase = ConfigUtils.inheritOverwritableProperty(this.kieBase, inheritedConfig.getKieBase());
        this.scoreDrlList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlList, inheritedConfig.getScoreDrlList());
        this.kieBaseConfigurationProperties = ConfigUtils.inheritMergeableMapProperty(this.kieBaseConfigurationProperties, inheritedConfig.getKieBaseConfigurationProperties());
        this.initializingScoreTrend = ConfigUtils.inheritOverwritableProperty(this.initializingScoreTrend, inheritedConfig.getInitializingScoreTrend());
        this.assertionScoreDirectorFactory = ConfigUtils.inheritOverwritableProperty(this.assertionScoreDirectorFactory, inheritedConfig.getAssertionScoreDirectorFactory());
    }

    public static enum ScoreDefinitionType {
        SIMPLE,
        SIMPLE_LONG,
        SIMPLE_DOUBLE,
        SIMPLE_BIG_DECIMAL,
        HARD_SOFT,
        HARD_SOFT_LONG,
        HARD_SOFT_DOUBLE,
        HARD_SOFT_BIG_DECIMAL,
        HARD_MEDIUM_SOFT,
        HARD_MEDIUM_SOFT_LONG,
        BENDABLE;

    }
}

