/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.phase.SolverPhase;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.random.DefaultRandomFactory;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="solver")
public class SolverConfig {
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    protected EnvironmentMode environmentMode = null;
    protected RandomType randomType = null;
    protected Long randomSeed = null;
    protected Class<? extends RandomFactory> randomFactoryClass = null;
    protected Class<? extends Solution> solutionClass = null;
    @XStreamImplicit(itemFieldName="planningEntityClass")
    protected List<Class<?>> planningEntityClassList = null;
    @XStreamAlias(value="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig;
    @XStreamImplicit
    protected List<SolverPhaseConfig> solverPhaseConfigList = null;

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public void setRandomType(RandomType randomType) {
        this.randomType = randomType;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<? extends RandomFactory> getRandomFactoryClass() {
        return this.randomFactoryClass;
    }

    public void setRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public List<Class<?>> getPlanningEntityClassList() {
        return this.planningEntityClassList;
    }

    public void setPlanningEntityClassList(List<Class<?>> planningEntityClassList) {
        this.planningEntityClassList = planningEntityClassList;
    }

    public ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<SolverPhaseConfig> getSolverPhaseConfigList() {
        return this.solverPhaseConfigList;
    }

    public void setSolverPhaseConfigList(List<SolverPhaseConfig> solverPhaseConfigList) {
        this.solverPhaseConfigList = solverPhaseConfigList;
    }

    public Solver buildSolver() {
        RandomFactory randomFactory;
        EnvironmentMode environmentMode;
        DefaultSolver solver = new DefaultSolver();
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination();
        solver.setBasicPlumbingTermination(basicPlumbingTermination);
        EnvironmentMode environmentMode2 = environmentMode = this.environmentMode == null ? EnvironmentMode.REPRODUCIBLE : this.environmentMode;
        if (this.randomFactoryClass != null) {
            if (this.randomType != null || this.randomSeed != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (" + this.randomFactoryClass + ") has a non-null randomType (" + (Object)((Object)this.randomType) + ") or a non-null randomSeed (" + this.randomSeed + ").");
            }
            randomFactory = ConfigUtils.newInstance(this, "randomFactoryClass", this.randomFactoryClass);
        } else {
            RandomType randomType_ = this.randomType == null ? RandomType.JDK : this.randomType;
            Long randomSeed_ = this.randomSeed;
            if (this.randomSeed == null && environmentMode != EnvironmentMode.PRODUCTION) {
                randomSeed_ = 0L;
            }
            randomFactory = new DefaultRandomFactory(randomType_, randomSeed_);
        }
        solver.setRandomFactory(randomFactory);
        SolutionDescriptor solutionDescriptor = this.buildSolutionDescriptor();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = this.scoreDirectorFactoryConfig == null ? new ScoreDirectorFactoryConfig() : this.scoreDirectorFactoryConfig;
        ScoreDirectorFactory scoreDirectorFactory = scoreDirectorFactoryConfig_.buildScoreDirectorFactory(environmentMode, solutionDescriptor);
        solver.setScoreDirectorFactory(scoreDirectorFactory);
        HeuristicConfigPolicy configPolicy = new HeuristicConfigPolicy(environmentMode, scoreDirectorFactory);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        Termination termination = terminationConfig_.buildTermination(configPolicy, basicPlumbingTermination);
        solver.setTermination(termination);
        BestSolutionRecaller bestSolutionRecaller = this.buildBestSolutionRecaller(environmentMode);
        solver.setBestSolutionRecaller(bestSolutionRecaller);
        if (ConfigUtils.isEmptyCollection(this.solverPhaseConfigList)) {
            throw new IllegalArgumentException("Configure at least 1 phase (for example <localSearch>) in the solver configuration.");
        }
        ArrayList<SolverPhase> solverPhaseList = new ArrayList<SolverPhase>(this.solverPhaseConfigList.size());
        int phaseIndex = 0;
        for (SolverPhaseConfig solverPhaseConfig : this.solverPhaseConfigList) {
            SolverPhase solverPhase = solverPhaseConfig.buildSolverPhase(phaseIndex, configPolicy, bestSolutionRecaller, termination);
            solverPhaseList.add(solverPhase);
            ++phaseIndex;
        }
        solver.setSolverPhaseList(solverPhaseList);
        return solver;
    }

    protected BestSolutionRecaller buildBestSolutionRecaller(EnvironmentMode environmentMode) {
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecaller();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            bestSolutionRecaller.setAssertBestScoreIsUnmodified(true);
        }
        return bestSolutionRecaller;
    }

    protected SolutionDescriptor buildSolutionDescriptor() {
        if (this.solutionClass == null) {
            throw new IllegalArgumentException("Configure a <solutionClass> in the solver configuration.");
        }
        DescriptorPolicy descriptorPolicy = new DescriptorPolicy();
        SolutionDescriptor solutionDescriptor = new SolutionDescriptor(this.solutionClass);
        solutionDescriptor.processAnnotations(descriptorPolicy);
        if (ConfigUtils.isEmptyCollection(this.planningEntityClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <planningEntityClass> in the solver configuration.");
        }
        for (Class<?> planningEntityClass : this.planningEntityClassList) {
            EntityDescriptor entityDescriptor = new EntityDescriptor(solutionDescriptor, planningEntityClass);
            solutionDescriptor.addEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations(descriptorPolicy);
        }
        solutionDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        return solutionDescriptor;
    }

    public void inherit(SolverConfig inheritedConfig) {
        this.environmentMode = ConfigUtils.inheritOverwritableProperty(this.environmentMode, inheritedConfig.getEnvironmentMode());
        this.randomType = ConfigUtils.inheritOverwritableProperty(this.randomType, inheritedConfig.getRandomType());
        this.randomSeed = ConfigUtils.inheritOverwritableProperty(this.randomSeed, inheritedConfig.getRandomSeed());
        this.randomFactoryClass = ConfigUtils.inheritOverwritableProperty(this.randomFactoryClass, inheritedConfig.getRandomFactoryClass());
        this.solutionClass = ConfigUtils.inheritOverwritableProperty(this.solutionClass, inheritedConfig.getSolutionClass());
        this.planningEntityClassList = ConfigUtils.inheritMergeableListProperty(this.planningEntityClassList, inheritedConfig.getPlanningEntityClassList());
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = inheritedConfig.getScoreDirectorFactoryConfig();
        } else if (inheritedConfig.getScoreDirectorFactoryConfig() != null) {
            this.scoreDirectorFactoryConfig.inherit(inheritedConfig.getScoreDirectorFactoryConfig());
        }
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
        this.solverPhaseConfigList = ConfigUtils.inheritMergeableListProperty(this.solverPhaseConfigList, inheritedConfig.getSolverPhaseConfigList());
    }
}

