/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver.termination;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.solver.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.solver.termination.AndCompositeTermination;
import org.optaplanner.core.impl.solver.termination.BestScoreTermination;
import org.optaplanner.core.impl.solver.termination.OrCompositeTermination;
import org.optaplanner.core.impl.solver.termination.StepCountTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.termination.TimeMillisSpentTermination;
import org.optaplanner.core.impl.solver.termination.UnimprovedStepCountTermination;
import org.optaplanner.core.impl.solver.termination.UnimprovedTimeMillisSpentTermination;

@XStreamAlias(value="termination")
public class TerminationConfig
implements Cloneable {
    private Class<? extends Termination> terminationClass = null;
    private TerminationCompositionStyle terminationCompositionStyle = null;
    private Long millisecondsSpentLimit = null;
    private Long secondsSpentLimit = null;
    private Long minutesSpentLimit = null;
    private Long hoursSpentLimit = null;
    private Long unimprovedMillisecondsSpentLimit = null;
    private Long unimprovedSecondsSpentLimit = null;
    private Long unimprovedMinutesSpentLimit = null;
    private Long unimprovedHoursSpentLimit = null;
    private String bestScoreLimit = null;
    private Integer stepCountLimit = null;
    private Integer unimprovedStepCountLimit = null;
    @XStreamImplicit(itemFieldName="termination")
    private List<TerminationConfig> terminationConfigList = null;

    public Class<? extends Termination> getTerminationClass() {
        return this.terminationClass;
    }

    public void setTerminationClass(Class<? extends Termination> terminationClass) {
        this.terminationClass = terminationClass;
    }

    public TerminationCompositionStyle getTerminationCompositionStyle() {
        return this.terminationCompositionStyle;
    }

    public void setTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
    }

    public Long getMillisecondsSpentLimit() {
        return this.millisecondsSpentLimit;
    }

    public void setMillisecondsSpentLimit(Long millisecondsSpentLimit) {
        this.millisecondsSpentLimit = millisecondsSpentLimit;
    }

    public Long getSecondsSpentLimit() {
        return this.secondsSpentLimit;
    }

    public void setSecondsSpentLimit(Long secondsSpentLimit) {
        this.secondsSpentLimit = secondsSpentLimit;
    }

    public Long getMinutesSpentLimit() {
        return this.minutesSpentLimit;
    }

    public void setMinutesSpentLimit(Long minutesSpentLimit) {
        this.minutesSpentLimit = minutesSpentLimit;
    }

    public Long getHoursSpentLimit() {
        return this.hoursSpentLimit;
    }

    public void setHoursSpentLimit(Long hoursSpentLimit) {
        this.hoursSpentLimit = hoursSpentLimit;
    }

    public Long getUnimprovedMillisecondsSpentLimit() {
        return this.unimprovedMillisecondsSpentLimit;
    }

    public void setUnimprovedMillisecondsSpentLimit(Long unimprovedMillisecondsSpentLimit) {
        this.unimprovedMillisecondsSpentLimit = unimprovedMillisecondsSpentLimit;
    }

    public Long getUnimprovedSecondsSpentLimit() {
        return this.unimprovedSecondsSpentLimit;
    }

    public void setUnimprovedSecondsSpentLimit(Long unimprovedSecondsSpentLimit) {
        this.unimprovedSecondsSpentLimit = unimprovedSecondsSpentLimit;
    }

    public Long getUnimprovedMinutesSpentLimit() {
        return this.unimprovedMinutesSpentLimit;
    }

    public void setUnimprovedMinutesSpentLimit(Long unimprovedMinutesSpentLimit) {
        this.unimprovedMinutesSpentLimit = unimprovedMinutesSpentLimit;
    }

    public Long getUnimprovedHoursSpentLimit() {
        return this.unimprovedHoursSpentLimit;
    }

    public void setUnimprovedHoursSpentLimit(Long unimprovedHoursSpentLimit) {
        this.unimprovedHoursSpentLimit = unimprovedHoursSpentLimit;
    }

    public String getBestScoreLimit() {
        return this.bestScoreLimit;
    }

    public void setBestScoreLimit(String bestScoreLimit) {
        this.bestScoreLimit = bestScoreLimit;
    }

    public Integer getStepCountLimit() {
        return this.stepCountLimit;
    }

    public void setStepCountLimit(Integer stepCountLimit) {
        this.stepCountLimit = stepCountLimit;
    }

    public Integer getUnimprovedStepCountLimit() {
        return this.unimprovedStepCountLimit;
    }

    public void setUnimprovedStepCountLimit(Integer unimprovedStepCountLimit) {
        this.unimprovedStepCountLimit = unimprovedStepCountLimit;
    }

    public List<TerminationConfig> getTerminationConfigList() {
        return this.terminationConfigList;
    }

    public void setTerminationConfigList(List<TerminationConfig> terminationConfigList) {
        this.terminationConfigList = terminationConfigList;
    }

    public Termination buildTermination(HeuristicConfigPolicy configPolicy, Termination chainedTermination) {
        Termination termination = this.buildTermination(configPolicy);
        if (termination == null) {
            return chainedTermination;
        }
        return new OrCompositeTermination(chainedTermination, termination);
    }

    public Termination buildTermination(HeuristicConfigPolicy configPolicy) {
        Long unimprovedTimeMillisSpentLimit;
        Long timeMillisSpentLimit;
        ArrayList<Termination> terminationList = new ArrayList<Termination>();
        if (this.terminationClass != null) {
            Termination termination = ConfigUtils.newInstance(this, "terminationClass", this.terminationClass);
            terminationList.add(termination);
        }
        if ((timeMillisSpentLimit = this.calculateTimeMillisSpentLimit()) != null) {
            terminationList.add(new TimeMillisSpentTermination(timeMillisSpentLimit));
        }
        if ((unimprovedTimeMillisSpentLimit = this.calculateUnimprovedTimeMillisSpentLimit()) != null) {
            terminationList.add(new UnimprovedTimeMillisSpentTermination(unimprovedTimeMillisSpentLimit));
        }
        if (this.bestScoreLimit != null) {
            Object bestScoreLimit_ = configPolicy.getScoreDefinition().parseScore(this.bestScoreLimit);
            terminationList.add(new BestScoreTermination((Score)bestScoreLimit_));
        }
        if (this.stepCountLimit != null) {
            terminationList.add(new StepCountTermination(this.stepCountLimit));
        }
        if (this.unimprovedStepCountLimit != null) {
            terminationList.add(new UnimprovedStepCountTermination(this.unimprovedStepCountLimit));
        }
        if (!ConfigUtils.isEmptyCollection(this.terminationConfigList)) {
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                Termination termination = terminationConfig.buildTermination(configPolicy);
                if (termination == null) continue;
                terminationList.add(termination);
            }
        }
        if (terminationList.size() == 1) {
            return (Termination)terminationList.get(0);
        }
        if (terminationList.size() > 1) {
            AbstractCompositeTermination compositeTermination;
            if (this.terminationCompositionStyle == null || this.terminationCompositionStyle == TerminationCompositionStyle.OR) {
                compositeTermination = new OrCompositeTermination(terminationList);
            } else if (this.terminationCompositionStyle == TerminationCompositionStyle.AND) {
                compositeTermination = new AndCompositeTermination(terminationList);
            } else {
                throw new IllegalStateException("The terminationCompositionStyle (" + (Object)((Object)this.terminationCompositionStyle) + ") is not implemented.");
            }
            return compositeTermination;
        }
        return null;
    }

    public Long calculateTimeMillisSpentLimit() {
        if (this.millisecondsSpentLimit == null && this.secondsSpentLimit == null && this.minutesSpentLimit == null && this.hoursSpentLimit == null) {
            return null;
        }
        long timeMillisSpentLimit = 0L;
        if (this.millisecondsSpentLimit != null) {
            timeMillisSpentLimit += this.millisecondsSpentLimit.longValue();
        }
        if (this.secondsSpentLimit != null) {
            timeMillisSpentLimit += this.secondsSpentLimit * 1000L;
        }
        if (this.minutesSpentLimit != null) {
            timeMillisSpentLimit += this.minutesSpentLimit * 60000L;
        }
        if (this.hoursSpentLimit != null) {
            timeMillisSpentLimit += this.hoursSpentLimit * 3600000L;
        }
        return timeMillisSpentLimit;
    }

    public void shortenTimeMillisSpentLimit(long timeMillisSpentLimit) {
        Long oldLimit = this.calculateTimeMillisSpentLimit();
        if (oldLimit == null || timeMillisSpentLimit < oldLimit) {
            this.millisecondsSpentLimit = timeMillisSpentLimit;
            this.secondsSpentLimit = null;
            this.minutesSpentLimit = null;
            this.hoursSpentLimit = null;
        }
    }

    public Long calculateUnimprovedTimeMillisSpentLimit() {
        if (this.unimprovedMillisecondsSpentLimit == null && this.unimprovedSecondsSpentLimit == null && this.unimprovedMinutesSpentLimit == null && this.unimprovedHoursSpentLimit == null) {
            return null;
        }
        long unimprovedTimeMillisSpentLimit = 0L;
        if (this.unimprovedMillisecondsSpentLimit != null) {
            unimprovedTimeMillisSpentLimit += this.unimprovedMillisecondsSpentLimit.longValue();
        }
        if (this.unimprovedSecondsSpentLimit != null) {
            unimprovedTimeMillisSpentLimit += this.unimprovedSecondsSpentLimit * 1000L;
        }
        if (this.unimprovedMinutesSpentLimit != null) {
            unimprovedTimeMillisSpentLimit += this.unimprovedMinutesSpentLimit * 60000L;
        }
        if (this.unimprovedHoursSpentLimit != null) {
            unimprovedTimeMillisSpentLimit += this.unimprovedHoursSpentLimit * 3600000L;
        }
        return unimprovedTimeMillisSpentLimit;
    }

    public void inherit(TerminationConfig inheritedConfig) {
        this.terminationClass = ConfigUtils.inheritOverwritableProperty(this.terminationClass, inheritedConfig.getTerminationClass());
        this.terminationCompositionStyle = ConfigUtils.inheritOverwritableProperty(this.terminationCompositionStyle, inheritedConfig.getTerminationCompositionStyle());
        this.millisecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.millisecondsSpentLimit, inheritedConfig.getMillisecondsSpentLimit());
        this.secondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.secondsSpentLimit, inheritedConfig.getSecondsSpentLimit());
        this.minutesSpentLimit = ConfigUtils.inheritOverwritableProperty(this.minutesSpentLimit, inheritedConfig.getMinutesSpentLimit());
        this.hoursSpentLimit = ConfigUtils.inheritOverwritableProperty(this.hoursSpentLimit, inheritedConfig.getHoursSpentLimit());
        this.unimprovedMillisecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedMillisecondsSpentLimit, inheritedConfig.getUnimprovedMillisecondsSpentLimit());
        this.unimprovedSecondsSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedSecondsSpentLimit, inheritedConfig.getUnimprovedSecondsSpentLimit());
        this.unimprovedMinutesSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedMinutesSpentLimit, inheritedConfig.getUnimprovedMinutesSpentLimit());
        this.unimprovedHoursSpentLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedHoursSpentLimit, inheritedConfig.getUnimprovedHoursSpentLimit());
        this.bestScoreLimit = ConfigUtils.inheritOverwritableProperty(this.bestScoreLimit, inheritedConfig.getBestScoreLimit());
        this.stepCountLimit = ConfigUtils.inheritOverwritableProperty(this.stepCountLimit, inheritedConfig.getStepCountLimit());
        this.unimprovedStepCountLimit = ConfigUtils.inheritOverwritableProperty(this.unimprovedStepCountLimit, inheritedConfig.getUnimprovedStepCountLimit());
        this.terminationConfigList = ConfigUtils.inheritMergeableListProperty(this.terminationConfigList, inheritedConfig.getTerminationConfigList());
    }

    public TerminationConfig clone() {
        TerminationConfig clone;
        try {
            clone = (TerminationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state because TerminationConfig implements Cloneable.", e);
        }
        if (this.terminationConfigList != null) {
            ArrayList<TerminationConfig> clonedTerminationConfigList = new ArrayList<TerminationConfig>(this.terminationConfigList.size());
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                TerminationConfig clonedTerminationConfig = terminationConfig.clone();
                clonedTerminationConfigList.add(clonedTerminationConfig);
            }
            clone.terminationConfigList = clonedTerminationConfigList;
        } else {
            clone.terminationConfigList = null;
        }
        return clone;
    }

    public static enum TerminationCompositionStyle {
        AND,
        OR;

    }
}

