/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.solution.Solution;

public class GenuineVariableDescriptor {
    private final EntityDescriptor entityDescriptor;
    private final PropertyAccessor variablePropertyAccessor;
    private boolean chained;
    private ValueRangeDescriptor valueRangeDescriptor;
    private boolean nullable;
    private SelectionFilter reinitializeVariableEntityFilter;
    private SelectionSorter increasingStrengthSorter;
    private List<ShadowVariableDescriptor> shadowVariableDescriptorList = new ArrayList<ShadowVariableDescriptor>(4);
    private List<VariableListener> nonMappedByVariableListeners;

    public GenuineVariableDescriptor(EntityDescriptor entityDescriptor, PropertyDescriptor propertyDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.variablePropertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(PlanningVariable.class);
        this.processMappedBy(descriptorPolicy, planningVariableAnnotation);
        this.processNullable(descriptorPolicy, planningVariableAnnotation);
        this.processChained(descriptorPolicy, planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation);
        this.processStrength(descriptorPolicy, planningVariableAnnotation);
        this.processVariableListeners(descriptorPolicy, planningVariableAnnotation);
    }

    private void processMappedBy(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        String mappedBy = planningVariableAnnotation.mappedBy();
        if (!mappedBy.equals("")) {
            throw new IllegalStateException("Impossible state: the " + EntityDescriptor.class + " would never try to build a " + GenuineVariableDescriptor.class + " for a shadow variable with mappedBy (" + mappedBy + ").");
        }
    }

    private void processNullable(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variablePropertyAccessor.getPropertyType().isPrimitive()) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variablePropertyAccessor.getPropertyType() + ").");
        }
        Class<? extends SelectionFilter> reinitializeVariableEntityFilterClass = planningVariableAnnotation.reinitializeVariableEntityFilter();
        if (reinitializeVariableEntityFilterClass == PlanningVariable.NullReinitializeVariableEntityFilter.class) {
            reinitializeVariableEntityFilterClass = null;
        }
        this.reinitializeVariableEntityFilter = reinitializeVariableEntityFilterClass != null ? ConfigUtils.newInstance(this, "reinitializeVariableEntityFilterClass", reinitializeVariableEntityFilterClass) : new NullValueReinitializeVariableEntityFilter(this);
    }

    private void processChained(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.chained = planningVariableAnnotation.chained();
        if (this.chained && !this.variablePropertyAccessor.getPropertyType().isAssignableFrom(this.entityDescriptor.getEntityClass())) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.variablePropertyAccessor.getPropertyType() + ") which is not a superclass/interface of or the same as the planningEntityClass (" + this.entityDescriptor.getEntityClass() + ").");
        }
        if (this.chained && this.nullable) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    private void processValueRangeRefs(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Object[] valueRangeProviderRefs = planningVariableAnnotation.valueRangeProviderRefs();
        if (ArrayUtils.isEmpty((Object[])valueRangeProviderRefs)) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variablePropertyAccessor.getName() + ") that has no valueRangeProviderRefs (" + Arrays.toString(valueRangeProviderRefs) + ").");
        }
        ArrayList<ValueRangeDescriptor> valueRangeDescriptorList = new ArrayList<ValueRangeDescriptor>(valueRangeProviderRefs.length);
        boolean addNullInValueRange = this.nullable && valueRangeProviderRefs.length == 1;
        for (Object valueRangeProviderRef : valueRangeProviderRefs) {
            valueRangeDescriptorList.add(this.buildValueRangeDescriptor(descriptorPolicy, (String)valueRangeProviderRef, addNullInValueRange));
        }
        this.valueRangeDescriptor = valueRangeDescriptorList.size() == 1 ? (ValueRangeDescriptor)valueRangeDescriptorList.get(0) : new CompositeValueRangeDescriptor(this, this.nullable, valueRangeDescriptorList);
    }

    private ValueRangeDescriptor buildValueRangeDescriptor(DescriptorPolicy descriptorPolicy, String valueRangeProviderRef, boolean addNullInValueRange) {
        if (descriptorPolicy.hasFromSolutionValueRangeProvider(valueRangeProviderRef)) {
            Method readMethod = descriptorPolicy.getFromSolutionValueRangeProvider(valueRangeProviderRef);
            return new FromSolutionPropertyValueRangeDescriptor(this, addNullInValueRange, readMethod);
        }
        if (descriptorPolicy.hasFromEntityValueRangeProvider(valueRangeProviderRef)) {
            Method readMethod = descriptorPolicy.getFromEntityValueRangeProvider(valueRangeProviderRef);
            return new FromEntityPropertyValueRangeDescriptor(this, addNullInValueRange, readMethod);
        }
        throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + ") annotated property (" + this.variablePropertyAccessor.getName() + ") with a valueRangeProviderRef (" + valueRangeProviderRef + ") that does not exist on a registered " + PlanningSolution.class.getSimpleName() + " or " + PlanningEntity.class.getSimpleName() + ".\n" + "The valueRangeProviderRef (" + valueRangeProviderRef + ") does not appear in valueRangeProvideIds (" + descriptorPolicy.getValueRangeProviderIds() + ").");
    }

    private void processStrength(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass;
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.entityDescriptor.getEntityClass() + ") property (" + this.variablePropertyAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this, "strengthComparatorClass", strengthComparatorClass);
            this.increasingStrengthSorter = new ComparatorSelectionSorter(strengthComparator, SelectionSorterOrder.ASCENDING);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.increasingStrengthSorter = new WeightFactorySelectionSorter(strengthWeightFactory, SelectionSorterOrder.ASCENDING);
        }
    }

    private void processVariableListeners(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Class<? extends VariableListener>[] variableListenerClasses = planningVariableAnnotation.variableListenerClasses();
        this.nonMappedByVariableListeners = new ArrayList<VariableListener>(variableListenerClasses.length);
        for (Class<? extends VariableListener> variableListenerClass : variableListenerClasses) {
            this.nonMappedByVariableListeners.add(ConfigUtils.newInstance(this, "variableListenerClass", variableListenerClass));
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
    }

    public void registerShadowVariableDescriptor(ShadowVariableDescriptor shadowVariableDescriptor) {
        this.shadowVariableDescriptorList.add(shadowVariableDescriptor);
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variablePropertyAccessor.getName();
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyAccessor.getPropertyType();
    }

    public boolean matchesEntityVariable(Object entity, String variableName) {
        return variableName.equals(this.getVariableName()) && this.entityDescriptor.matchesEntity(entity);
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public SelectionFilter getReinitializeVariableEntityFilter() {
        return this.reinitializeVariableEntityFilter;
    }

    public ValueRangeDescriptor getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public List<VariableListener> buildVariableListenerList() {
        ArrayList<VariableListener> variableListenerList = new ArrayList<VariableListener>(this.shadowVariableDescriptorList.size() + this.nonMappedByVariableListeners.size());
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.shadowVariableDescriptorList) {
            variableListenerList.add(shadowVariableDescriptor.buildVariableListener());
        }
        for (VariableListener variableListener : this.nonMappedByVariableListeners) {
            variableListenerList.add(variableListener);
        }
        return variableListenerList;
    }

    public boolean isInitialized(Object entity) {
        if (this.nullable) {
            return true;
        }
        Object variable = this.getValue(entity);
        return variable != null;
    }

    public Object getValue(Object entity) {
        return this.variablePropertyAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variablePropertyAccessor.executeSetter(entity, value);
    }

    public SelectionSorter getIncreasingStrengthSorter() {
        return this.increasingStrengthSorter;
    }

    public long getValueCount(Solution solution, Object entity) {
        if (!this.valueRangeDescriptor.isCountable()) {
            return 0L;
        }
        return ((CountableValueRange)this.valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyAccessor.getName() + " of " + this.entityDescriptor.getEntityClass().getName() + ")";
    }
}

