/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedMoveUtils {
    public static void doChainedChange(ScoreDirector scoreDirector, Object entity, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        Object newTrailingEntity;
        Object oldPlanningValue = variableDescriptor.getValue(entity);
        Object oldTrailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, entity);
        Object object = newTrailingEntity = toPlanningValue == null ? null : scoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        scoreDirector.beforeVariableChanged(entity, variableDescriptor.getVariableName());
        if (newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldPlanningValue);
        }
        variableDescriptor.setValue(entity, toPlanningValue);
        if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, entity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        scoreDirector.afterVariableChanged(entity, variableDescriptor.getVariableName());
        if (newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
    }

    public static void doSubChainChange(ScoreDirector scoreDirector, SubChain subChain, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        Object firstEntity = subChain.getFirstEntity();
        Object lastEntity = subChain.getLastEntity();
        Object oldFirstPlanningValue = variableDescriptor.getValue(firstEntity);
        Object oldTrailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, lastEntity);
        Object newTrailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        scoreDirector.beforeVariableChanged(firstEntity, variableDescriptor.getVariableName());
        if (newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldFirstPlanningValue);
        }
        variableDescriptor.setValue(firstEntity, toPlanningValue);
        if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, lastEntity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        scoreDirector.afterVariableChanged(firstEntity, variableDescriptor.getVariableName());
        if (newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
    }

    public static void doReverseSubChainChange(ScoreDirector scoreDirector, SubChain subChain, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        Object entity;
        Object firstEntity = subChain.getFirstEntity();
        Object lastEntity = subChain.getLastEntity();
        Object oldFirstPlanningValue = variableDescriptor.getValue(firstEntity);
        Object oldTrailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, lastEntity);
        Object newTrailingEntity = scoreDirector.getTrailingEntity(variableDescriptor, toPlanningValue);
        boolean unmovedReverse = firstEntity == newTrailingEntity;
        List<Object> entityList = subChain.getEntityList();
        if (oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        ListIterator<Object> it = entityList.listIterator(entityList.size());
        while (it.hasPrevious()) {
            Object entity2 = it.previous();
            scoreDirector.beforeVariableChanged(entity2, variableDescriptor.getVariableName());
        }
        if (!unmovedReverse && newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
        if (oldTrailingEntity != null) {
            variableDescriptor.setValue(oldTrailingEntity, oldFirstPlanningValue);
        }
        Object nextEntity = toPlanningValue;
        ListIterator<Object> it2 = entityList.listIterator(entityList.size());
        while (it2.hasPrevious()) {
            entity = it2.previous();
            variableDescriptor.setValue(entity, nextEntity);
            nextEntity = entity;
        }
        if (unmovedReverse) {
            if (oldTrailingEntity != null) {
                variableDescriptor.setValue(oldTrailingEntity, firstEntity);
            }
        } else if (newTrailingEntity != null) {
            variableDescriptor.setValue(newTrailingEntity, firstEntity);
        }
        if (oldTrailingEntity != null) {
            scoreDirector.afterVariableChanged(oldTrailingEntity, variableDescriptor.getVariableName());
        }
        it2 = entityList.listIterator(entityList.size());
        while (it2.hasPrevious()) {
            entity = it2.previous();
            scoreDirector.afterVariableChanged(entity, variableDescriptor.getVariableName());
        }
        if (!unmovedReverse && newTrailingEntity != null) {
            scoreDirector.afterVariableChanged(newTrailingEntity, variableDescriptor.getVariableName());
        }
    }

    private ChainedMoveUtils() {
    }
}

